/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.party;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.feature.party.PartyService;
import dev.lrxh.neptune.feature.party.impl.PartyRequest;
import dev.lrxh.neptune.profile.ProfileService;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.ClickableComponent;
import dev.lrxh.neptune.providers.clickable.Replacement;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Party {
    private final HashSet<UUID> users;
    private final boolean duelRequest;
    private final Neptune plugin;
    private UUID leader;
    private boolean open;
    private int maxUsers;

    public Party(UUID leader, int max, Neptune plugin) {
        this.leader = leader;
        this.users = new HashSet();
        this.users.add(leader);
        this.open = false;
        this.maxUsers = max;
        this.duelRequest = true;
        this.plugin = plugin;
        this.setupPlayer(leader);
    }

    public String getLeaderName() {
        Player player = Bukkit.getPlayer((UUID)this.leader);
        if (player == null) {
            this.users.remove(this.leader);
            return "";
        }
        return player.getName();
    }

    public boolean isLeader(UUID playerUUID) {
        return this.leader == playerUUID;
    }

    public void invite(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        TextComponent accept = new ClickableComponent(MessagesLocale.PARTY_ACCEPT.getString().replace("<leader>", this.getLeaderName()), "/party accept " + String.valueOf(this.leader), MessagesLocale.PARTY_ACCEPT_HOVER.getString()).build();
        MessagesLocale.PARTY_INVITATION.send(playerUUID, new Replacement("<accept>", accept), new Replacement("<leader>", this.getLeaderName()));
        Profile profile = API.getProfile(playerUUID);
        profile.getGameData().addRequest(new PartyRequest(this.leader, this), this.leader, ignore -> MessagesLocale.PARTY_EXPIRED.send(this.leader, new Replacement("<player>", player.getName())));
    }

    public void accept(UUID playerUUID) {
        if (this.users.size() + 1 > this.maxUsers) {
            return;
        }
        this.setupPlayer(playerUUID);
    }

    private void setupPlayer(UUID playerUUID) {
        Player invitedPlayer = Bukkit.getPlayer((UUID)playerUUID);
        if (invitedPlayer == null) {
            return;
        }
        this.users.add(playerUUID);
        Profile profile = API.getProfile(playerUUID);
        profile.getGameData().setParty(this);
        profile.setState(ProfileState.IN_PARTY);
        if (playerUUID != this.leader) {
            this.broadcast(MessagesLocale.PARTY_JOINED, new Replacement("<player>", invitedPlayer.getName()));
        }
        API.getProfile(playerUUID).getGameData().removeRequest(this.leader);
    }

    public void kick(UUID playerUUID) {
        this.broadcast(MessagesLocale.PARTY_KICK, new Replacement("<player>", this.getLeaderName()));
        this.remove(playerUUID);
    }

    public void remove(UUID playerUUID) {
        if (this.leader == playerUUID) {
            this.disband();
            return;
        }
        Profile profile = API.getProfile(playerUUID);
        this.users.remove(playerUUID);
        profile.setState(ProfileState.IN_LOBBY);
        profile.getGameData().setParty(null);
    }

    public void disband() {
        this.broadcast(MessagesLocale.PARTY_DISBANDED, new Replacement[0]);
        this.forEachMemberAsUUID(uuid -> {
            Profile profile = API.getProfile(uuid);
            profile.getGameData().setParty(null);
            if (profile.getState().equals(ProfileState.IN_PARTY)) {
                profile.setState(ProfileState.IN_LOBBY);
            }
        });
        PartyService.get().removeParty(this);
    }

    public void broadcast(MessagesLocale messagesLocale, Replacement ... replacements) {
        this.forEachMemberAsUUID(uuid -> messagesLocale.send((UUID)uuid, replacements));
    }

    public String getUserNames() {
        StringBuilder playerNames = new StringBuilder();
        this.forEachMemberAsPlayer(player -> {
            if (!playerNames.isEmpty()) {
                playerNames.append(MessagesLocale.MATCH_COMMA.getString());
            }
            playerNames.append(player.getName());
        });
        return playerNames.toString();
    }

    public void forEachMemberAsPlayer(Consumer<Player> action) {
        for (UUID user : this.users) {
            Player player = Bukkit.getPlayer((UUID)user);
            if (player == null) continue;
            action.accept(player);
        }
    }

    public void forEachMemberAsUUID(Consumer<UUID> action) {
        for (UUID user : this.users) {
            action.accept(user);
        }
    }

    public void transfer(Player player, Player target) {
        this.setLeader(target.getUniqueId());
        this.broadcast(MessagesLocale.PARTY_TRANSFER, new Replacement("<leader>", player.getName()), new Replacement("<target>", target.getName()));
    }

    public boolean advertise() {
        Profile leaderProfile = API.getProfile(this.leader);
        if (leaderProfile.hasCooldownEnded("party_advertise")) {
            leaderProfile.addCooldown("party_advertise", 300000);
            this.setOpen(true);
            for (Profile profile : ProfileService.get().profiles.values()) {
                TextComponent join = new ClickableComponent(MessagesLocale.PARTY_ADVERTISE_JOIN.getString(), "/party join " + this.getLeaderName(), MessagesLocale.PARTY_ADVERTISE_JOIN_HOVER.getString().replaceAll("<leader>", this.getLeaderName())).build();
                MessagesLocale.PARTY_ADVERTISE_MESSAGE.send(profile.getPlayerUUID(), new Replacement("<join>", join), new Replacement("<leader>", this.getLeaderName()));
            }
            return true;
        }
        return false;
    }

    @Generated
    public HashSet<UUID> getUsers() {
        return this.users;
    }

    @Generated
    public boolean isDuelRequest() {
        return this.duelRequest;
    }

    @Generated
    public Neptune getPlugin() {
        return this.plugin;
    }

    @Generated
    public UUID getLeader() {
        return this.leader;
    }

    @Generated
    public boolean isOpen() {
        return this.open;
    }

    @Generated
    public int getMaxUsers() {
        return this.maxUsers;
    }

    @Generated
    public void setLeader(UUID leader) {
        this.leader = leader;
    }

    @Generated
    public void setOpen(boolean open) {
        this.open = open;
    }

    @Generated
    public void setMaxUsers(int maxUsers) {
        this.maxUsers = maxUsers;
    }
}

