/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.party.menu.buttons.events;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.party.Party;
import dev.lrxh.neptune.feature.party.impl.EventType;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class PartyTeamKitButton
extends Button {
    private final Party party;
    private final Kit kit;
    private final EventType eventType;

    public PartyTeamKitButton(int slot, Party party, Kit kit, EventType eventType) {
        super(slot, false);
        this.party = party;
        this.kit = kit;
        this.eventType = eventType;
    }

    @Override
    public void onClick(ClickType type, Player player) {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        for (UUID uuid : this.party.getUsers()) {
            Player user = Bukkit.getPlayer((UUID)uuid);
            if (user == null) continue;
            participants.add(new Participant(user));
        }
        this.eventType.start(participants, this.kit);
    }

    @Override
    public ItemStack getItemStack(Player player) {
        return new ItemBuilder(this.kit.getIcon()).name(MenusLocale.PARTY_EVENTS_KIT_SELECT_NAME.getString().replace("<kit>", this.kit.getDisplayName())).lore(MenusLocale.PARTY_EVENTS_KIT_SELECT_LORE.getStringList(), player).build();
    }
}

