/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.queue;

import dev.lrxh.api.events.QueueJoinEvent;
import dev.lrxh.api.kit.IKit;
import dev.lrxh.api.profile.IProfileState;
import dev.lrxh.api.queue.IQueueEntry;
import dev.lrxh.api.queue.IQueueService;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.feature.queue.QueueEntry;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class QueueService
implements IQueueService {
    private static QueueService instance;
    private final Map<Kit, Queue<QueueEntry>> kitQueues = new HashMap<Kit, Queue<QueueEntry>>();

    public static QueueService get() {
        if (instance == null) {
            instance = new QueueService();
        }
        return instance;
    }

    public void add(QueueEntry queueEntry, boolean add) {
        UUID playerUUID = queueEntry.getUuid();
        Kit kit = queueEntry.getKit();
        if (this.get(playerUUID) != null) {
            return;
        }
        Profile profile = API.getProfile(playerUUID);
        if (!profile.hasState((IProfileState)ProfileState.IN_LOBBY)) {
            return;
        }
        if (profile.getGameData().getParty() != null) {
            return;
        }
        if (queueEntry.getKit().is(KitRule.HIDDEN)) {
            return;
        }
        this.kitQueues.computeIfAbsent(kit, k -> new ConcurrentLinkedQueue()).offer(queueEntry);
        if (add) {
            QueueJoinEvent event = new QueueJoinEvent(queueEntry);
            Bukkit.getScheduler().runTask((Plugin)Neptune.get(), () -> Bukkit.getPluginManager().callEvent((Event)event));
            if (event.isCancelled()) {
                return;
            }
            profile.setState(ProfileState.IN_QUEUE);
            kit.addQueue();
            MessagesLocale.QUEUE_JOIN.send(playerUUID, new Replacement("<kit>", kit.getDisplayName()), new Replacement("<maxPing>", String.valueOf(profile.getSettingData().getMaxPing())));
        }
    }

    @Override
    public QueueEntry remove(UUID playerUUID) {
        QueueEntry entry = this.get(playerUUID);
        if (entry == null) {
            return null;
        }
        Kit kit = entry.getKit();
        Queue<QueueEntry> queue = this.kitQueues.get(kit);
        if (queue != null) {
            queue.remove(entry);
            entry.getKit().removeQueue();
        }
        return entry;
    }

    public void remove(QueueEntry queueEntry) {
        this.remove(queueEntry.getUuid());
    }

    public QueueEntry poll(Kit kit) {
        Queue<QueueEntry> queue = this.kitQueues.get(kit);
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        ArrayList<QueueEntry> entries = new ArrayList<QueueEntry>(queue);
        return this.remove(((QueueEntry)entries.get(new Random().nextInt(entries.size()))).getUuid());
    }

    @Override
    public QueueEntry get(UUID uuid) {
        for (Queue<QueueEntry> queue : this.kitQueues.values()) {
            for (QueueEntry entry : queue) {
                if (!entry.getUuid().equals(uuid)) continue;
                return entry;
            }
        }
        return null;
    }

    @Override
    public int getQueueSize() {
        return QueueService.get().getAllQueues().values().stream().mapToInt(Collection::size).sum();
    }

    public Map<Kit, Queue<QueueEntry>> getAllQueues() {
        return this.kitQueues;
    }

    @Override
    public Map<IKit, Queue<IQueueEntry>> getQueues() {
        return this.kitQueues.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((IKit)entry.getKey(), (Queue)((Queue)entry.getValue()).stream().map(e -> e).collect(Collectors.toCollection(LinkedList::new))), HashMap::putAll);
    }
}

