/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.feature.queue.menu;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.feature.leaderboard.LeaderboardService;
import dev.lrxh.neptune.feature.leaderboard.impl.LeaderboardType;
import dev.lrxh.neptune.feature.leaderboard.impl.PlayerEntry;
import dev.lrxh.neptune.feature.queue.QueueEntry;
import dev.lrxh.neptune.feature.queue.QueueService;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class QueueSelectButton
extends Button {
    private final Kit kit;

    public QueueSelectButton(int slot, Kit kit) {
        super(slot);
        this.kit = kit;
    }

    @Override
    public ItemStack getItemStack(Player player) {
        ArrayList<String> lore = new ArrayList<String>();
        MenusLocale.QUEUE_SELECT_LORE.getStringList().forEach(line -> {
            String[] split = line.split("_");
            if (split.length != 3) {
                lore.add((String)line);
                return;
            }
            LeaderboardType leaderboardType = LeaderboardType.value(split[1]);
            if (leaderboardType == null) {
                lore.add((String)line);
                return;
            }
            List<PlayerEntry> leaderboard = LeaderboardService.get().getPlayerEntries(this.kit, leaderboardType);
            int i = Integer.parseInt(split[2]);
            PlayerEntry playerEntry = null;
            if (i <= leaderboard.size()) {
                playerEntry = LeaderboardService.get().getLeaderboardSlot(this.kit, leaderboardType, i);
            }
            if (playerEntry == null) {
                line = line.replaceAll("<player_" + split[1] + "_" + i + ">", "???");
                line = line.replaceAll("<value" + split[1] + "_" + i + ">", "???");
            } else {
                line = line.replaceAll("<player_" + split[1] + "_" + i + ">", playerEntry.getUsername());
                line = line.replaceAll("<value" + split[1] + "_" + i + ">", String.valueOf(playerEntry.getValue()));
            }
            lore.add((String)line);
        });
        return new ItemBuilder(this.kit.getIcon()).name(MenusLocale.QUEUE_SELECT_KIT_NAME.getString().replace("<kit>", this.kit.getDisplayName())).lore(ItemUtils.getLore(lore, new Replacement("<kit>", this.kit.getDisplayName()), new Replacement("<kitName>", this.kit.getName()), new Replacement("<playing>", String.valueOf(this.kit.getPlaying())), new Replacement("<queue>", String.valueOf(this.kit.getQueue()))), player).amount(this.kit.getQueue()).build();
    }

    @Override
    public void onClick(ClickType type, Player player) {
        QueueService.get().add(new QueueEntry(this.kit, player.getUniqueId()), true);
        player.closeInventory();
    }
}

