/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.arena;

import dev.lrxh.api.arena.IArena;
import dev.lrxh.blockChanger.snapshot.CuboidSnapshot;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.game.arena.ArenaService;
import dev.lrxh.neptune.game.arena.allocator.Allocation;
import dev.lrxh.neptune.game.arena.allocator.SpatialAllocator;
import dev.lrxh.neptune.game.kit.KitService;
import dev.lrxh.neptune.utils.LocationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;

public class Arena
implements IArena {
    private String name;
    private String displayName;
    private Location redSpawn;
    private Location blueSpawn;
    private boolean enabled;
    private int deathY;
    private Location min;
    private Location max;
    private double buildLimit;
    private List<Material> whitelistedBlocks;
    private CuboidSnapshot snapshot;
    private AtomicInteger duplicateIndex;
    private Arena owner;
    private boolean doneLoading;
    private boolean used;
    private Long allocationId;

    public Arena(String name, String displayName, Location redSpawn, Location blueSpawn, boolean enabled, int deathY) {
        this.name = name;
        this.displayName = displayName;
        this.redSpawn = redSpawn;
        this.blueSpawn = blueSpawn;
        this.enabled = enabled;
        this.deathY = deathY;
        this.buildLimit = 0.0;
        this.whitelistedBlocks = new ArrayList<Material>();
        this.duplicateIndex = new AtomicInteger(1);
        this.doneLoading = false;
    }

    public Arena(String name, String displayName, Location redSpawn, Location blueSpawn, Location min, Location max, double buildLimit, boolean enabled, List<Material> whitelistedBlocks, int deathY) {
        this(name, displayName, redSpawn, blueSpawn, enabled, deathY);
        this.min = min;
        this.max = max;
        this.buildLimit = buildLimit;
        ArrayList arrayList = this.whitelistedBlocks = whitelistedBlocks != null ? whitelistedBlocks : new ArrayList();
        if (min != null && max != null) {
            this.doneLoading = false;
            CuboidSnapshot.create(min, max).thenAccept(cuboidSnapshot -> {
                this.snapshot = cuboidSnapshot;
                this.doneLoading = true;
            });
        }
    }

    public Arena(String name, String displayName, Location redSpawn, Location blueSpawn, Location min, Location max, double buildLimit, boolean enabled, List<Material> whitelistedBlocks, int deathY, CuboidSnapshot snapshot, Arena owner, Long allocationId) {
        this(name, displayName, redSpawn, blueSpawn, min, max, buildLimit, enabled, whitelistedBlocks, deathY);
        this.snapshot = snapshot;
        this.owner = owner;
        this.doneLoading = snapshot != null;
        this.allocationId = allocationId;
    }

    public Arena(String name) {
        this(name, name, null, null, false, -68321);
        this.min = null;
        this.max = null;
        this.buildLimit = 68321.0;
        this.whitelistedBlocks = new ArrayList<Material>();
        this.duplicateIndex = new AtomicInteger(1);
    }

    @Override
    public boolean isSetup() {
        return this.redSpawn != null && this.blueSpawn != null && this.min != null && this.max != null;
    }

    public synchronized CompletableFuture<Arena> createDuplicate() {
        Allocation allocation;
        if (this.snapshot == null) {
            CompletableFuture<Arena> failed = new CompletableFuture<Arena>();
            failed.completeExceptionally(new IllegalStateException("CuboidSnapshot not ready"));
            return failed;
        }
        AtomicInteger indexCounter = this.owner != null ? this.owner.duplicateIndex : this.duplicateIndex;
        int currentIndex = indexCounter.getAndIncrement();
        int arenaWidthBlocks = Math.abs(this.max.getBlockX() - this.min.getBlockX()) + 1;
        int arenaDepthBlocks = Math.abs(this.max.getBlockZ() - this.min.getBlockZ()) + 1;
        int widthWithOffsetBlocks = arenaWidthBlocks + SettingsLocale.ARENA_COPY_OFFSET_X.getInt();
        int depthWithOffsetBlocks = arenaDepthBlocks + SettingsLocale.ARENA_COPY_OFFSET_Z.getInt();
        int widthChunks = (widthWithOffsetBlocks + 15) / 16;
        int depthChunks = (depthWithOffsetBlocks + 15) / 16;
        try {
            allocation = SpatialAllocator.get().allocate(widthChunks, depthChunks);
        }
        catch (Exception ex) {
            CompletableFuture<Arena> failed = new CompletableFuture<Arena>();
            failed.completeExceptionally(new IllegalStateException("Unable to reserve space for arena duplicate", ex));
            return failed;
        }
        int originalMinChunkX = this.min.getBlockX() >> 4;
        int originalMinChunkZ = this.min.getBlockZ() >> 4;
        int chunkOffsetX = allocation.chunkX - originalMinChunkX;
        int chunkOffsetZ = allocation.chunkZ - originalMinChunkZ;
        int offsetBlocksX = chunkOffsetX * 16;
        int offsetBlocksZ = chunkOffsetZ * 16;
        Location newRedSpawn = this.redSpawn != null ? LocationUtil.addOffset(this.redSpawn.clone(), offsetBlocksX, offsetBlocksZ) : null;
        Location newBlueSpawn = this.blueSpawn != null ? LocationUtil.addOffset(this.blueSpawn.clone(), offsetBlocksX, offsetBlocksZ) : null;
        Location newMin = LocationUtil.addOffset(this.min.clone(), offsetBlocksX, offsetBlocksZ);
        Location newMax = LocationUtil.addOffset(this.max.clone(), offsetBlocksX, offsetBlocksZ);
        CompletableFuture<Arena> future = new CompletableFuture<Arena>();
        ((CompletableFuture)this.snapshot.offset(offsetBlocksX, offsetBlocksZ).thenApplyAsync(cuboidSnapshot -> {
            cuboidSnapshot.restore(false);
            return new Arena(this.name + "#" + currentIndex, this.displayName, newRedSpawn, newBlueSpawn, newMin, newMax, this.buildLimit, this.enabled, this.whitelistedBlocks, this.deathY, (CuboidSnapshot)cuboidSnapshot, this, allocation.id);
        })).whenComplete((arena, throwable) -> {
            if (throwable != null) {
                SpatialAllocator.get().free(allocation.id);
                future.completeExceptionally((Throwable)throwable);
            } else {
                future.complete((Arena)arena);
            }
        });
        return future;
    }

    public List<String> getWhitelistedBlocksAsString() {
        ArrayList<String> result = new ArrayList<String>();
        for (Material mat : this.whitelistedBlocks) {
            result.add(mat.name());
        }
        return result;
    }

    @Override
    public void remove() {
        if (SettingsLocale.ARENA_DUPLICATES.getBoolean()) {
            this.used = false;
            return;
        }
        if (this.allocationId != null) {
            try {
                SpatialAllocator.get().free(this.allocationId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.allocationId = null;
        }
        if (this.owner != null) {
            this.owner.duplicateIndex.getAndDecrement();
        }
    }

    @Override
    public void restore() {
        if (this.snapshot != null) {
            this.snapshot.restore(true);
        }
    }

    @Override
    public void setMin(Location min) {
        this.min = min;
        if (min != null && this.max != null) {
            this.doneLoading = false;
            CuboidSnapshot.create(min, this.max).thenAccept(cuboidSnapshot -> {
                this.snapshot = cuboidSnapshot;
                this.doneLoading = true;
            });
        }
    }

    @Override
    public void setMax(Location max) {
        this.max = max;
        if (this.min != null && max != null) {
            this.doneLoading = false;
            CuboidSnapshot.create(this.min, max).thenAccept(cuboidSnapshot -> {
                this.snapshot = cuboidSnapshot;
                this.doneLoading = true;
            });
        }
    }

    @Override
    public void setRedSpawn(Location redSpawn) {
        this.redSpawn = redSpawn;
        if (this.buildLimit == 68321.0) {
            this.buildLimit = redSpawn.getBlockY() + 5;
        }
    }

    @Override
    public void setBlueSpawn(Location blueSpawn) {
        this.blueSpawn = blueSpawn;
        if (this.buildLimit == 68321.0) {
            this.buildLimit = blueSpawn.getBlockY() + 5;
        }
    }

    @Override
    public void delete(boolean save) {
        KitService.get().removeArenasFromKits(this);
        ArenaService.get().arenas.remove(this);
        if (this.allocationId != null) {
            SpatialAllocator.get().free(this.allocationId);
            this.allocationId = null;
        }
        if (save) {
            ArenaService.get().save();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Arena) {
            Arena arena = (Arena)o;
            return arena.getName().equals(this.name);
        }
        return false;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public Location getRedSpawn() {
        return this.redSpawn;
    }

    @Override
    @Generated
    public Location getBlueSpawn() {
        return this.blueSpawn;
    }

    @Override
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Generated
    public int getDeathY() {
        return this.deathY;
    }

    @Override
    @Generated
    public Location getMin() {
        return this.min;
    }

    @Override
    @Generated
    public Location getMax() {
        return this.max;
    }

    @Override
    @Generated
    public double getBuildLimit() {
        return this.buildLimit;
    }

    @Override
    @Generated
    public List<Material> getWhitelistedBlocks() {
        return this.whitelistedBlocks;
    }

    @Generated
    public CuboidSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Generated
    public AtomicInteger getDuplicateIndex() {
        return this.duplicateIndex;
    }

    @Override
    @Generated
    public Arena getOwner() {
        return this.owner;
    }

    @Generated
    public boolean isDoneLoading() {
        return this.doneLoading;
    }

    @Generated
    public boolean isUsed() {
        return this.used;
    }

    @Generated
    public Long getAllocationId() {
        return this.allocationId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setDeathY(int deathY) {
        this.deathY = deathY;
    }

    @Generated
    public void setBuildLimit(double buildLimit) {
        this.buildLimit = buildLimit;
    }

    @Generated
    public void setWhitelistedBlocks(List<Material> whitelistedBlocks) {
        this.whitelistedBlocks = whitelistedBlocks;
    }

    @Generated
    public void setSnapshot(CuboidSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    @Generated
    public void setDuplicateIndex(AtomicInteger duplicateIndex) {
        this.duplicateIndex = duplicateIndex;
    }

    @Generated
    public void setOwner(Arena owner) {
        this.owner = owner;
    }

    @Generated
    public void setDoneLoading(boolean doneLoading) {
        this.doneLoading = doneLoading;
    }

    @Generated
    public void setUsed(boolean used) {
        this.used = used;
    }

    @Generated
    public void setAllocationId(Long allocationId) {
        this.allocationId = allocationId;
    }
}

