/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.arena;

import dev.lrxh.api.arena.IArena;
import dev.lrxh.api.arena.IArenaService;
import dev.lrxh.neptune.configs.ConfigService;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.providers.manager.IService;
import dev.lrxh.neptune.providers.manager.Value;
import dev.lrxh.neptune.utils.ConfigFile;
import dev.lrxh.neptune.utils.LocationUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class ArenaService
extends IService
implements IArenaService {
    private static ArenaService instance;
    public final LinkedHashSet<Arena> arenas = new LinkedHashSet();

    public static ArenaService get() {
        if (instance == null) {
            instance = new ArenaService();
        }
        return instance;
    }

    @Override
    public LinkedHashSet<IArena> getAllArenas() {
        return this.arenas.stream().collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    @Override
    public void load() {
        YamlConfiguration config = ConfigService.get().getArenasConfig().getConfiguration();
        if (config.contains("arenas")) {
            for (String arenaName : this.getKeys("arenas")) {
                Arena arena = this.loadArena(arenaName);
                this.arenas.add(arena);
            }
        }
    }

    public Arena loadArena(String arenaName) {
        String path;
        YamlConfiguration config = ConfigService.get().getArenasConfig().getConfiguration();
        if (!config.contains((path = "arenas." + arenaName + ".") + "displayName")) {
            return null;
        }
        String displayName = config.getString(path + "displayName");
        Location redSpawn = LocationUtil.deserialize(config.getString(path + "redSpawn"));
        Location blueSpawn = LocationUtil.deserialize(config.getString(path + "blueSpawn"));
        boolean enabled = config.getBoolean(path + "enabled");
        int deathY = config.getInt(path + "deathY", -68321);
        Location edge1 = LocationUtil.deserialize(config.getString(path + "min"));
        Location edge2 = LocationUtil.deserialize(config.getString(path + "max"));
        double limit = config.getDouble(path + "limit");
        ArrayList<Material> whitelistedBlocks = new ArrayList<Material>();
        for (String name : config.getStringList(path + "whitelistedBlocks")) {
            whitelistedBlocks.add(Material.getMaterial((String)name));
        }
        return new Arena(arenaName, displayName, redSpawn, blueSpawn, edge1, edge2, limit, enabled, whitelistedBlocks, deathY);
    }

    @Override
    public void save() {
        this.getConfigFile().getConfiguration().getKeys(false).forEach(key -> this.getConfigFile().getConfiguration().set(key, null));
        this.arenas.forEach(arena -> {
            String path = "arenas." + arena.getName() + ".";
            ArrayList<Value> values = new ArrayList<Value>(Arrays.asList(new Value("displayName", arena.getDisplayName()), new Value("redSpawn", LocationUtil.serialize(arena.getRedSpawn())), new Value("blueSpawn", LocationUtil.serialize(arena.getBlueSpawn())), new Value("enabled", arena.isEnabled()), new Value("deathY", arena.getDeathY()), new Value("limit", arena.getBuildLimit()), new Value("whitelistedBlocks", arena.getWhitelistedBlocksAsString())));
            if (arena.getMin() != null) {
                values.add(new Value("min", LocationUtil.serialize(arena.getMin())));
            }
            if (arena.getMax() != null) {
                values.add(new Value("max", LocationUtil.serialize(arena.getMax())));
            }
            this.save(values, path);
        });
    }

    @Override
    public Arena getArenaByName(String arenaName) {
        for (Arena arena : this.arenas) {
            if (arena == null || arena.getName() == null || !arena.getName().equalsIgnoreCase(arenaName)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public ConfigFile getConfigFile() {
        return ConfigService.get().getArenasConfig();
    }

    @Generated
    public LinkedHashSet<Arena> getArenas() {
        return this.arenas;
    }
}

