/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.arena.allocator;

import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.game.arena.allocator.Allocation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SpatialAllocator {
    private static final int DEFAULT_BASE_X = SettingsLocale.ARENA_COPY_OFFSET_X.getInt();
    private static final int DEFAULT_BASE_Z = SettingsLocale.ARENA_COPY_OFFSET_Z.getInt();
    private static final SpatialAllocator INSTANCE = new SpatialAllocator(DEFAULT_BASE_X, DEFAULT_BASE_Z);
    private final ConcurrentHashMap<Long, Long> occupancy = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Allocation> allocations = new ConcurrentHashMap();
    private final AtomicLong idCounter = new AtomicLong(1L);
    private final int baseChunkX;
    private final int baseChunkZ;
    private int nextX = 0;
    private int nextZ = 0;

    private SpatialAllocator(int baseChunkX, int baseChunkZ) {
        this.baseChunkX = baseChunkX;
        this.baseChunkZ = baseChunkZ;
    }

    private static long keyFor(int cx, int cz) {
        return (long)cx << 32 | (long)cz & 0xFFFFFFFFL;
    }

    public static SpatialAllocator get() {
        return INSTANCE;
    }

    public synchronized Allocation allocate(int widthChunks, int depthChunks, int gutterChunks, int maxRadius) {
        if (widthChunks <= 0 || depthChunks <= 0) {
            throw new IllegalArgumentException("widthChunks/depthChunks must be > 0");
        }
        int strideX = widthChunks + Math.max(0, gutterChunks);
        int strideZ = depthChunks + Math.max(0, gutterChunks);
        int allocX = this.baseChunkX + this.nextX;
        int allocZ = this.baseChunkZ + this.nextZ;
        while (!this.regionFree(allocX, allocZ, widthChunks, depthChunks)) {
            this.nextX += strideX;
            if (this.nextX > 10000) {
                this.nextX = 0;
                this.nextZ += strideZ;
            }
            allocX = this.baseChunkX + this.nextX;
            allocZ = this.baseChunkZ + this.nextZ;
        }
        Allocation alloc = this.reserveAt(allocX, allocZ, widthChunks, depthChunks);
        this.nextX += strideX;
        return alloc;
    }

    public Allocation allocate(int widthChunks, int depthChunks) {
        return this.allocate(widthChunks, depthChunks, 1, 200);
    }

    private boolean regionFree(int startChunkX, int startChunkZ, int widthChunks, int depthChunks) {
        for (int x = startChunkX; x < startChunkX + widthChunks; ++x) {
            for (int z = startChunkZ; z < startChunkZ + depthChunks; ++z) {
                if (!this.occupancy.containsKey(SpatialAllocator.keyFor(x, z))) continue;
                return false;
            }
        }
        return true;
    }

    private Allocation reserveAt(int startChunkX, int startChunkZ, int widthChunks, int depthChunks) {
        long id = this.idCounter.getAndIncrement();
        Allocation alloc = new Allocation(id, startChunkX, startChunkZ, widthChunks, depthChunks);
        try {
            int z;
            int x;
            this.allocations.put(id, alloc);
            for (int x2 = startChunkX; x2 < startChunkX + widthChunks; ++x2) {
                for (int z2 = startChunkZ; z2 < startChunkZ + depthChunks; ++z2) {
                    this.occupancy.put(SpatialAllocator.keyFor(x2, z2), id);
                }
            }
            int mismatches = 0;
            for (x = startChunkX; x < startChunkX + widthChunks; ++x) {
                for (z = startChunkZ; z < startChunkZ + depthChunks; ++z) {
                    Long val = this.occupancy.get(SpatialAllocator.keyFor(x, z));
                    if (val != null && val == id) continue;
                    ++mismatches;
                }
            }
            if (mismatches > 0) {
                for (x = startChunkX; x < startChunkX + widthChunks; ++x) {
                    for (z = startChunkZ; z < startChunkZ + depthChunks; ++z) {
                        this.occupancy.remove(SpatialAllocator.keyFor(x, z), id);
                    }
                }
                this.allocations.remove(id);
                throw new IllegalStateException("SpatialAllocator: failed to reserve full region for id=" + id);
            }
            return alloc;
        }
        catch (RuntimeException ex) {
            for (int x = startChunkX; x < startChunkX + widthChunks; ++x) {
                for (int z = startChunkZ; z < startChunkZ + depthChunks; ++z) {
                    this.occupancy.remove(SpatialAllocator.keyFor(x, z), id);
                }
            }
            this.allocations.remove(id);
            throw ex;
        }
    }

    public synchronized void free(long allocationId) {
        Allocation alloc = this.allocations.remove(allocationId);
        if (alloc == null) {
            return;
        }
        for (int x = alloc.chunkX; x < alloc.chunkX + alloc.widthChunks; ++x) {
            for (int z = alloc.chunkZ; z < alloc.chunkZ + alloc.depthChunks; ++z) {
                this.occupancy.remove(SpatialAllocator.keyFor(x, z), allocationId);
            }
        }
    }
}

