/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.arena.menu;

import dev.lrxh.blockChanger.snapshot.CuboidSnapshot;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.arena.impl.EdgeType;
import dev.lrxh.neptune.game.arena.menu.ArenasManagementMenu;
import dev.lrxh.neptune.game.arena.menu.WhitelistedBlocksMenu;
import dev.lrxh.neptune.game.arena.menu.button.ArenaDeleteButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaEnableButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaRenameButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaSetDeathYButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaSetEdgeButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaSetLimitButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaSetSpawnButton;
import dev.lrxh.neptune.game.arena.menu.button.ArenaSetupButton;
import dev.lrxh.neptune.game.match.impl.participant.ParticipantColor;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.Menu;
import dev.lrxh.neptune.utils.menu.impl.DisplayButton;
import dev.lrxh.neptune.utils.menu.impl.ReturnButton;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ArenaManagementMenu
extends Menu {
    private final Arena arena;

    public ArenaManagementMenu(Arena arena) {
        super("&eManage Arena", 45, Filter.FILL);
        this.arena = arena;
    }

    @Override
    public List<Button> getButtons(Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        if (!this.arena.isSetup() || !this.arena.isDoneLoading()) {
            buttons.add(new ArenaSetupButton(22, this.arena));
        } else {
            buttons.add(new ArenaSetSpawnButton(0, this.arena, ParticipantColor.BLUE));
            buttons.add(new ArenaSetSpawnButton(1, this.arena, ParticipantColor.RED));
            buttons.add(new ArenaEnableButton(this.getSize() - 1, this.arena));
            buttons.add(new ArenaRenameButton(23, this.arena));
            buttons.add(new DisplayButton(22, Material.MAP, "&aTeleport to arena", o -> player.teleport(this.arena.getBlueSpawn())));
            buttons.add(new ArenaDeleteButton(21, this.arena));
            buttons.add(new ArenaSetDeathYButton(9, this.arena));
            buttons.add(new ArenaSetLimitButton(4, this.arena));
            buttons.add(new DisplayButton(this.getSize() - 5, Material.GRASS_BLOCK, "&aManage Whitelisted Blocks", o -> new WhitelistedBlocksMenu(this.arena).open(player)));
            buttons.add(new ArenaSetEdgeButton(8, this.arena, EdgeType.MAX));
            buttons.add(new ArenaSetEdgeButton(7, this.arena, EdgeType.MIN));
            buttons.add(new Button(31){

                @Override
                public ItemStack getItemStack(Player player) {
                    return new ItemBuilder(Material.EMERALD).name("&aRecapture Arena").build();
                }

                @Override
                public void onClick(ClickType type, Player player) {
                    ArenaManagementMenu.this.arena.setDoneLoading(false);
                    CuboidSnapshot.create(ArenaManagementMenu.this.arena.getMin(), ArenaManagementMenu.this.arena.getMax()).thenAccept(snapshot -> {
                        ArenaManagementMenu.this.arena.setSnapshot((CuboidSnapshot)snapshot);
                        ArenaManagementMenu.this.arena.setDoneLoading(true);
                    });
                }
            });
        }
        buttons.add(new ReturnButton(this.getSize() - 9, new ArenasManagementMenu()));
        return buttons;
    }
}

