/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.arena.menu;

import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.arena.menu.ArenaManagementMenu;
import dev.lrxh.neptune.game.arena.menu.button.AddWhitelistBlockButton;
import dev.lrxh.neptune.game.arena.menu.button.WhitelistedBlockButton;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.PaginatedMenu;
import dev.lrxh.neptune.utils.menu.impl.ReturnButton;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class WhitelistedBlocksMenu
extends PaginatedMenu {
    private final Arena arena;

    public WhitelistedBlocksMenu(Arena arena) {
        super("&eWhitelisted Blocks", 54, Filter.NONE);
        this.arena = arena;
    }

    @Override
    public List<Button> getAllPagesButtons(Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        int i = 0;
        for (Material material : this.arena.getWhitelistedBlocks()) {
            buttons.add(new WhitelistedBlockButton(i++, material, this.arena));
        }
        return buttons;
    }

    @Override
    public List<Button> getGlobalButtons(Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        buttons.add(new ReturnButton(this.getSize() - 9, new ArenaManagementMenu(this.arena)));
        buttons.add(new AddWhitelistBlockButton(this.getSize() - 5, this.arena));
        return buttons;
    }

    @Override
    public int getMaxItemsPerPage() {
        return 36;
    }
}

