/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.arena.procedure;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.arena.ArenaService;
import dev.lrxh.neptune.game.arena.menu.ArenaManagementMenu;
import dev.lrxh.neptune.game.arena.menu.ArenasManagementMenu;
import dev.lrxh.neptune.game.arena.menu.WhitelistedBlocksMenu;
import dev.lrxh.neptune.game.arena.procedure.ArenaProcedureType;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import io.papermc.paper.event.player.AsyncChatEvent;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class ArenaProcedureListener
implements Listener {
    @EventHandler
    public void onChat(AsyncChatEvent event) {
        final Player player = event.getPlayer();
        final Profile profile = API.getProfile(player);
        String input = PlainTextComponentSerializer.plainText().serialize(event.message());
        if (input.equalsIgnoreCase("Cancel") && !profile.getArenaProcedure().getType().equals((Object)ArenaProcedureType.NONE)) {
            event.setCancelled(true);
            player.sendMessage((Component)CC.success("Canceled Procedure"));
            profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
            return;
        }
        switch (profile.getArenaProcedure().getType()) {
            case CREATE: {
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                if (ArenaService.get().getArenaByName(input) != null) {
                    player.sendMessage((Component)CC.error("Arena already exists"));
                    return;
                }
                if (input.contains(" ")) {
                    player.sendMessage((Component)CC.error("Arena name cannot contain spaces"));
                    return;
                }
                Arena arena = new Arena(input);
                ArenaService.get().arenas.add(arena);
                player.sendMessage((Component)CC.success("Created arena"));
                new ArenasManagementMenu().open(player);
                ArenaService.get().save();
                break;
            }
            case RENAME: {
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                profile.getArenaProcedure().getArena().setDisplayName(input);
                player.sendMessage((Component)CC.success("Renamed arena"));
                new ArenaManagementMenu(profile.getArenaProcedure().getArena()).open(player);
                profile.getArenaProcedure().setArena(null);
                break;
            }
            case SET_SPAWN_RED: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                final Arena arena = profile.getArenaProcedure().getArena();
                if (!arena.isSetup() || !arena.isDoneLoading()) {
                    profile.getArenaProcedure().setType(ArenaProcedureType.SET_SPAWN_BLUE);
                    player.sendMessage((Component)CC.success("Set arena red spawn"));
                    arena.setRedSpawn(player.getLocation());
                    if (arena.getBlueSpawn() != null) {
                        new NeptuneRunnable(this){

                            public void run() {
                                player.teleport(arena.getBlueSpawn());
                            }
                        }.runTask((Plugin)Neptune.get());
                    }
                    player.sendMessage((Component)CC.info("Go to the spawn of the &9blue &7player and type &aDone"));
                    break;
                }
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                arena.setRedSpawn(player.getLocation());
                new ArenaManagementMenu(arena).open(player);
                player.sendMessage((Component)CC.success("Set arena red &aspawn"));
                profile.getArenaProcedure().setArena(null);
                break;
            }
            case SET_SPAWN_BLUE: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                Arena arena = profile.getArenaProcedure().getArena();
                if (!arena.isSetup() || !arena.isDoneLoading()) {
                    arena.setBlueSpawn(player.getLocation());
                    profile.getArenaProcedure().setType(ArenaProcedureType.SET_SPAWN_MIN);
                    player.sendMessage((Component)CC.info("Go to the lowest edge of the arena and type &aDone"));
                    return;
                }
                player.sendMessage((Component)CC.success("Set arena blue spawn"));
                arena.setBlueSpawn(player.getLocation());
                new ArenaManagementMenu(arena).open(player);
                profile.getArenaProcedure().setArena(null);
                break;
            }
            case SET_SPAWN_MAX: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                final Arena arena = profile.getArenaProcedure().getArena();
                if (!arena.isSetup() || !arena.isDoneLoading()) {
                    player.sendMessage((Component)CC.success("Arena setup complete"));
                } else {
                    player.sendMessage((Component)CC.success("Set arena max position"));
                }
                new NeptuneRunnable(this){

                    public void run() {
                        arena.setMax(player.getLocation());
                        new ArenaManagementMenu(profile.getArenaProcedure().getArena()).open(player);
                        profile.getArenaProcedure().setArena(null);
                    }
                }.start();
                break;
            }
            case SET_BUILD_LIMIT: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                Arena arena = profile.getArenaProcedure().getArena();
                arena.setBuildLimit(player.getLocation().getBlockY());
                new ArenaManagementMenu(profile.getArenaProcedure().getArena()).open(player);
                player.sendMessage((Component)CC.success("Set arena build limit"));
                profile.getArenaProcedure().setArena(null);
                break;
            }
            case SET_SPAWN_MIN: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                final Arena arena = profile.getArenaProcedure().getArena();
                if (!arena.isSetup() || !arena.isDoneLoading()) {
                    arena.setMin(player.getLocation());
                    profile.getArenaProcedure().setType(ArenaProcedureType.SET_SPAWN_MAX);
                    player.sendMessage((Component)CC.info("Go to the highest edge of the arena and type &aDone"));
                    return;
                }
                new NeptuneRunnable(this){

                    public void run() {
                        arena.setMin(player.getLocation());
                        player.sendMessage((Component)CC.success("Set arena min position"));
                        new ArenaManagementMenu(profile.getArenaProcedure().getArena()).open(player);
                        profile.getArenaProcedure().setArena(null);
                    }
                }.start();
                break;
            }
            case SET_DEATH_Y: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                profile.getArenaProcedure().getArena().setDeathY(player.getLocation().getBlockY());
                player.sendMessage((Component)CC.success("Set arena death Y position"));
                new ArenaManagementMenu(profile.getArenaProcedure().getArena()).open(player);
                profile.getArenaProcedure().setArena(null);
                break;
            }
            case ADD_BLOCK: {
                if (!input.equalsIgnoreCase("Done")) {
                    return;
                }
                event.setCancelled(true);
                if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.AIR)) {
                    player.sendMessage((Component)CC.error("Item can't be air"));
                    return;
                }
                profile.getArenaProcedure().setType(ArenaProcedureType.NONE);
                Arena arena = profile.getArenaProcedure().getArena();
                arena.getWhitelistedBlocks().add(player.getInventory().getItemInMainHand().getType());
                new WhitelistedBlocksMenu(arena).open(player);
                profile.getArenaProcedure().setArena(null);
            }
        }
        ArenaService.get().save();
    }

    @Generated
    public ArenaProcedureListener() {
    }
}

