/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.duel;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.match.MatchService;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.team.MatchTeam;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.request.Request;
import dev.lrxh.neptune.utils.CC;
import java.util.ArrayList;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DuelRequest
extends Request {
    private final Kit kit;
    private final Arena arena;
    private final boolean party;
    private final int rounds;

    public DuelRequest(UUID sender, Kit kit, Arena arena, boolean party, int rounds) {
        super(sender);
        this.kit = kit;
        this.arena = arena;
        this.party = party;
        this.rounds = rounds;
    }

    public void start(UUID receiver) {
        if (this.party) {
            this.partyDuel(receiver);
        } else {
            this.normalDuel(receiver);
        }
    }

    public void normalDuel(UUID receiver) {
        Player sender = Bukkit.getPlayer((UUID)this.getSender());
        Player reciverPlayer = Bukkit.getPlayer((UUID)receiver);
        if (reciverPlayer == null || sender == null) {
            return;
        }
        Participant participant1 = new Participant(sender);
        Participant participant2 = new Participant(reciverPlayer);
        MatchService.get().startMatch(participant1, participant2, this.kit, this.arena, true, this.rounds);
    }

    public void partyDuel(UUID receiver) {
        Profile receiverProfile = API.getProfile(receiver);
        Profile senderProfile = API.getProfile(this.getSender());
        ArrayList<Participant> participants = new ArrayList<Participant>();
        ArrayList<Participant> teamAList = new ArrayList<Participant>();
        for (UUID uUID : receiverProfile.getGameData().getParty().getUsers()) {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player == null) continue;
            Participant participant = new Participant(player);
            teamAList.add(participant);
            participants.add(participant);
        }
        ArrayList<Participant> teamBList = new ArrayList<Participant>();
        for (UUID userUUID : senderProfile.getGameData().getParty().getUsers()) {
            Player player = Bukkit.getPlayer((UUID)userUUID);
            if (player == null) continue;
            Participant participant = new Participant(player);
            teamBList.add(participant);
            participants.add(participant);
        }
        MatchTeam matchTeam = new MatchTeam(teamAList);
        MatchTeam teamB = new MatchTeam(teamBList);
        matchTeam.setOpponentTeam(teamB);
        teamB.setOpponentTeam(matchTeam);
        if (this.arena == null) {
            for (Participant participant : participants) {
                participant.sendMessage(CC.error("No arenas were found!"));
            }
            return;
        }
        if (!this.arena.isSetup() || !this.arena.isDoneLoading()) {
            for (Participant participant : participants) {
                participant.sendMessage(CC.error("Arena wasn't setup up properly! Please contact an admin if you see this."));
            }
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)Neptune.get(), () -> MatchService.get().startMatch(teamA, teamB, this.kit, this.arena));
    }

    @Generated
    public Kit getKit() {
        return this.kit;
    }

    @Generated
    public Arena getArena() {
        return this.arena;
    }

    @Generated
    public boolean isParty() {
        return this.party;
    }

    @Generated
    public int getRounds() {
        return this.rounds;
    }
}

