/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.duel.menu;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.duel.DuelRequest;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.Menu;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ArenaSelectMenu
extends Menu {
    private final Kit kit;
    private final UUID receiver;
    private final int round;

    public ArenaSelectMenu(Kit kit, UUID receiver, int round) {
        super(MenusLocale.ARENA_TITLE.getString(), MenusLocale.ARENA_SIZE.getInt(), Filter.valueOf(MenusLocale.ARENA_FILTER.getString()));
        this.kit = kit;
        this.receiver = receiver;
        this.round = round;
    }

    @Override
    public List<Button> getButtons(final Player player) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        int i = 1;
        buttons.add(new Button(MenusLocale.ARENA_RANDOM_ITEM_SLOT.getInt()){

            @Override
            public ItemStack getItemStack(Player p) {
                return new ItemBuilder(MenusLocale.ARENA_RANDOM_ITEM_MATERIAL.getString()).name(MenusLocale.ARENA_RANDOM_ITEM_NAME.getString()).lore(MenusLocale.ARENA_RANDOM_ITEM_LORE.getStringList()).build();
            }

            @Override
            public void onClick(ClickType type, Player p) {
                ArenaSelectMenu.this.kit.getRandomArena().thenAccept(arena -> {
                    Profile profile = API.getProfile(ArenaSelectMenu.this.receiver);
                    if (profile == null) {
                        return;
                    }
                    if (arena == null) {
                        p.sendMessage((Component)CC.error("No arena found, please contact an admin"));
                        return;
                    }
                    DuelRequest duelRequest = new DuelRequest(p.getUniqueId(), ArenaSelectMenu.this.kit, (Arena)arena, false, ArenaSelectMenu.this.round);
                    profile.sendDuel(duelRequest);
                    Bukkit.getScheduler().runTask((Plugin)Neptune.get(), () -> p.closeInventory());
                });
            }
        });
        for (final Arena arena : this.kit.getArenas()) {
            buttons.add(new Button(i++){

                @Override
                public ItemStack getItemStack(Player p) {
                    return new ItemBuilder(Material.MAP).name(MenusLocale.ARENA_ITEM_NAME.getString().replace("<arena>", arena.getName())).lore(MenusLocale.ARENA_ITEM_LORE.getStringList().stream().map(it -> it.replace("<arena>", arena.getName())).collect(Collectors.toList())).build();
                }

                @Override
                public void onClick(ClickType type, Player p) {
                    Profile profile = API.getProfile(ArenaSelectMenu.this.receiver);
                    if (profile == null) {
                        return;
                    }
                    player.closeInventory();
                    arena.createDuplicate().thenAccept(duplicate -> {
                        DuelRequest duelRequest = new DuelRequest(p.getUniqueId(), ArenaSelectMenu.this.kit, (Arena)duplicate, false, ArenaSelectMenu.this.round);
                        profile.sendDuel(duelRequest);
                    });
                }
            });
        }
        return buttons;
    }
}

