/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.kit;

import dev.lrxh.api.arena.IArena;
import dev.lrxh.api.kit.IKit;
import dev.lrxh.api.kit.IKitRule;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.KitService;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.profile.ProfileService;
import dev.lrxh.neptune.profile.data.GameData;
import dev.lrxh.neptune.profile.data.KitData;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.PlayerUtil;
import dev.lrxh.neptune.utils.PotionEffectUtils;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class Kit
implements IKit {
    private String name;
    private String displayName;
    private List<ItemStack> items;
    private HashSet<Arena> arenas;
    private ItemStack icon;
    private HashMap<KitRule, Boolean> rules;
    private int queue;
    private int playing;
    private int slot;
    private int kitEditorSlot;
    private double health;
    private List<PotionEffect> potionEffects;
    private double damageMultiplier;

    public Kit(String name, String displayName, List<ItemStack> items, HashSet<Arena> arenas, ItemStack icon, HashMap<KitRule, Boolean> rules, int slot, double health, int kitEditorSlot, List<PotionEffect> potionEffects, double damageMultiplier) {
        this.name = name;
        this.displayName = displayName;
        this.items = items;
        this.arenas = arenas;
        this.icon = icon;
        this.rules = rules;
        this.queue = 0;
        this.playing = 0;
        this.slot = slot;
        this.health = health;
        this.kitEditorSlot = kitEditorSlot;
        this.potionEffects = potionEffects;
        this.damageMultiplier = damageMultiplier;
        this.addToProfiles();
    }

    public Kit(String name, Player player) {
        this.name = name;
        this.displayName = "&7" + name;
        this.items = Arrays.stream(player.getInventory().getContents()).toList();
        this.arenas = new HashSet();
        this.icon = new ItemStack(Material.DIAMOND_SWORD);
        this.rules = this.rules();
        this.queue = 0;
        this.playing = 0;
        this.slot = KitService.get().kits.size() + 1;
        this.health = 20.0;
        this.kitEditorSlot = this.slot;
        this.damageMultiplier = 1.0;
        this.potionEffects = new ArrayList<PotionEffect>();
        for (PotionEffect effect : player.getActivePotionEffects()) {
            int currentDuration = effect.getDuration();
            int maxDuration = PlayerUtil.getMaxDuration(player, effect.getType());
            this.potionEffects.add(new PotionEffect(effect.getType(), Math.min(currentDuration, maxDuration), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon()));
        }
        this.addToProfiles();
    }

    public Kit(String name, List<ItemStack> items, ItemStack icon) {
        this.name = name;
        this.displayName = name;
        this.items = items;
        this.arenas = new HashSet();
        this.rules = this.rules();
        this.icon = icon.getType().equals((Object)Material.AIR) ? new ItemStack(Material.BARRIER) : new ItemStack(icon);
        this.queue = 0;
        this.playing = 0;
        this.slot = KitService.get().kits.size() + 1;
        this.health = 20.0;
        this.kitEditorSlot = this.slot;
        this.potionEffects = new ArrayList<PotionEffect>();
        this.damageMultiplier = 1.0;
        this.addToProfiles();
    }

    private HashMap<KitRule, Boolean> rules() {
        HashMap<KitRule, Boolean> rules = new HashMap<KitRule, Boolean>();
        for (KitRule kitRule : KitRule.values()) {
            rules.put(kitRule, false);
        }
        return rules;
    }

    public void toggleArena(Arena arena) {
        if (this.arenas.contains(arena)) {
            this.arenas.remove(arena);
            return;
        }
        this.arenas.add(arena);
    }

    public boolean isArenaAdded(Arena arena) {
        return this.arenas.contains(arena);
    }

    private void addToProfiles() {
        for (Profile profile : ProfileService.get().profiles.values()) {
            profile.getGameData().getKitDataInternal().put(this, new KitData());
        }
    }

    public List<String> getArenasAsString() {
        ArrayList<String> arenasString = new ArrayList<String>();
        if (!this.arenas.isEmpty()) {
            for (Arena arena : this.arenas) {
                if (arena == null) continue;
                arenasString.add(arena.getName());
            }
        }
        return arenasString;
    }

    public List<String> getPotionsAsString() {
        ArrayList<String> potions = new ArrayList<String>();
        if (!this.potionEffects.isEmpty()) {
            for (PotionEffect effect : this.potionEffects) {
                if (effect == null) continue;
                potions.add(PotionEffectUtils.serialize(effect));
            }
        }
        return potions;
    }

    public boolean is(KitRule kitRule) {
        return this.rules.get(kitRule);
    }

    public void toggle(KitRule kitRule) {
        this.rules.put(kitRule, this.rules.get(kitRule) == false);
    }

    public void removeQueue() {
        if (this.queue != 0) {
            --this.queue;
        }
    }

    public void addQueue() {
        ++this.queue;
    }

    public void removePlaying() {
        if (this.playing != 0) {
            --this.playing;
        }
    }

    @Override
    public HashMap<IKitRule, Boolean> getRule() {
        return this.rules.entrySet().stream().collect(HashMap::new, (map, entry) -> map.put((IKitRule)entry.getKey(), (Boolean)entry.getValue()), HashMap::putAll);
    }

    public CompletableFuture<Arena> getRandomArena() {
        ArrayList<Arena> arenas1 = new ArrayList<Arena>();
        for (Arena arena2 : this.arenas) {
            if (!arena2.isEnabled() || arena2.isUsed() && !SettingsLocale.ARENA_DUPLICATES.getBoolean() || !arena2.isSetup() || !arena2.isDoneLoading()) continue;
            arenas1.add(arena2);
        }
        if (arenas1.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Arena selected = (Arena)arenas1.get(ThreadLocalRandom.current().nextInt(arenas1.size()));
        if (!SettingsLocale.ARENA_DUPLICATES.getBoolean()) {
            selected.setUsed(true);
            return CompletableFuture.completedFuture(selected);
        }
        return selected.createDuplicate().thenApply(arena -> arena);
    }

    @Override
    public void giveLoadout(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        Profile profile = API.getProfile(playerUUID);
        GameData gameData = profile.getGameData();
        if (gameData.getKitData() == null || gameData.get(this) == null || gameData.get(this).getKitLoadout().isEmpty()) {
            player.getInventory().setContents(this.items.toArray(new ItemStack[0]));
        } else {
            player.getInventory().setContents(gameData.get(this).getKitLoadout().toArray(new ItemStack[0]));
        }
        player.addPotionEffects(this.potionEffects);
        player.updateInventory();
    }

    public void giveLoadout(Participant participant) {
        Player player = participant.getPlayer();
        if (player == null) {
            return;
        }
        Profile profile = API.getProfile(player);
        GameData gameData = profile.getGameData();
        if (gameData.getKitData() == null || gameData.get(this) == null || gameData.get(this).getKitLoadout().isEmpty()) {
            player.getInventory().setContents(ItemUtils.color(this.items.toArray(new ItemStack[0]), participant.getColor().getContentColor()));
        } else {
            player.getInventory().setContents(ItemUtils.color(gameData.get(this).getKitLoadout().toArray(new ItemStack[0]), participant.getColor().getContentColor()));
        }
        player.addPotionEffects(this.potionEffects);
        player.updateInventory();
    }

    public void addPlaying() {
        ++this.playing;
    }

    public void delete() {
        KitService.get().kits.remove(this);
        KitService.get().save();
    }

    @Override
    public HashSet<IArena> getAllArenas() {
        return this.arenas.stream().collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    public boolean equals(Object o) {
        if (o instanceof Kit) {
            Kit kit = (Kit)o;
            return kit.getName().equals(this.name);
        }
        return false;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Generated
    public HashSet<Arena> getArenas() {
        return this.arenas;
    }

    @Override
    @Generated
    public ItemStack getIcon() {
        return this.icon;
    }

    @Generated
    public HashMap<KitRule, Boolean> getRules() {
        return this.rules;
    }

    @Override
    @Generated
    public int getQueue() {
        return this.queue;
    }

    @Override
    @Generated
    public int getPlaying() {
        return this.playing;
    }

    @Override
    @Generated
    public int getSlot() {
        return this.slot;
    }

    @Override
    @Generated
    public int getKitEditorSlot() {
        return this.kitEditorSlot;
    }

    @Override
    @Generated
    public double getHealth() {
        return this.health;
    }

    @Override
    @Generated
    public List<PotionEffect> getPotionEffects() {
        return this.potionEffects;
    }

    @Override
    @Generated
    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setItems(List<ItemStack> items) {
        this.items = items;
    }

    @Generated
    public void setArenas(HashSet<Arena> arenas) {
        this.arenas = arenas;
    }

    @Generated
    public void setIcon(ItemStack icon) {
        this.icon = icon;
    }

    @Generated
    public void setRules(HashMap<KitRule, Boolean> rules) {
        this.rules = rules;
    }

    @Generated
    public void setQueue(int queue) {
        this.queue = queue;
    }

    @Generated
    public void setPlaying(int playing) {
        this.playing = playing;
    }

    @Generated
    public void setSlot(int slot) {
        this.slot = slot;
    }

    @Generated
    public void setKitEditorSlot(int kitEditorSlot) {
        this.kitEditorSlot = kitEditorSlot;
    }

    @Generated
    public void setHealth(double health) {
        this.health = health;
    }

    @Generated
    public void setPotionEffects(List<PotionEffect> potionEffects) {
        this.potionEffects = potionEffects;
    }

    @Generated
    public void setDamageMultiplier(double damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    @Generated
    public Kit(String name, String displayName, List<ItemStack> items, HashSet<Arena> arenas, ItemStack icon, HashMap<KitRule, Boolean> rules, int queue, int playing, int slot, int kitEditorSlot, double health, List<PotionEffect> potionEffects, double damageMultiplier) {
        this.name = name;
        this.displayName = displayName;
        this.items = items;
        this.arenas = arenas;
        this.icon = icon;
        this.rules = rules;
        this.queue = queue;
        this.playing = playing;
        this.slot = slot;
        this.kitEditorSlot = kitEditorSlot;
        this.health = health;
        this.potionEffects = potionEffects;
        this.damageMultiplier = damageMultiplier;
    }
}

