/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.kit;

import dev.lrxh.api.arena.IArena;
import dev.lrxh.api.kit.IKit;
import dev.lrxh.api.kit.IKitService;
import dev.lrxh.neptune.configs.ConfigService;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.arena.ArenaService;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.providers.manager.IService;
import dev.lrxh.neptune.providers.manager.Value;
import dev.lrxh.neptune.utils.ConfigFile;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.PotionEffectUtils;
import dev.lrxh.neptune.utils.ServerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class KitService
extends IService
implements IKitService {
    private static KitService instance;
    public final LinkedHashSet<Kit> kits = new LinkedHashSet();

    public static KitService get() {
        if (instance == null) {
            instance = new KitService();
        }
        return instance;
    }

    @Override
    public void load() {
        YamlConfiguration config = ConfigService.get().getKitsConfig().getConfiguration();
        if (config.contains("kits")) {
            for (String kitName : this.getKeys("kits")) {
                String path = "kits." + kitName + ".";
                String displayName = config.getString(path + "displayName", kitName);
                ItemStack icon = ItemUtils.deserializeItem(config.getString(path + "icon", ""));
                List<ItemStack> items = ItemUtils.deserialize(config.getString(path + "items", ""));
                int slot = config.getInt(path + "slot", this.kits.size() + 1);
                int kitEditorSlot = config.getInt(path + "kitEditor-slot", slot);
                double health = config.getDouble(path + "health", 20.0);
                double damageMultiplier = config.getDouble(path + "damage-multiplier", 1.0);
                HashSet<Arena> arenas = new HashSet<Arena>();
                if (!config.getStringList(path + "arenas").isEmpty()) {
                    for (String string : config.getStringList(path + "arenas")) {
                        Arena arena = ArenaService.get().getArenaByName(string);
                        if (arena == null) {
                            ServerUtils.error("KitService: Arena " + string + " not found for kit " + kitName);
                            continue;
                        }
                        arenas.add(arena);
                    }
                }
                HashMap<KitRule, Boolean> rules = new HashMap<KitRule, Boolean>();
                for (KitRule kitRule : KitRule.values()) {
                    rules.put(kitRule, config.getBoolean(path + kitRule.getSaveName(), false));
                }
                ArrayList<PotionEffect> arrayList = new ArrayList<PotionEffect>();
                if (!config.getStringList(path + "potionEffects").isEmpty()) {
                    for (String potion : config.getStringList(path + "potionEffects")) {
                        arrayList.add(PotionEffectUtils.deserialize(potion));
                    }
                }
                this.kits.add(new Kit(kitName, displayName, items, arenas, icon, rules, slot, health, kitEditorSlot, arrayList, damageMultiplier));
            }
        }
    }

    public boolean add(Kit kit) {
        for (Kit k : this.kits) {
            if (!k.equals(kit)) continue;
            return true;
        }
        this.kits.add(kit);
        return false;
    }

    @Override
    public boolean addKit(IKit kit) {
        return this.add((Kit)kit);
    }

    @Override
    public void save() {
        this.getConfigFile().getConfiguration().getKeys(false).forEach(key -> this.getConfigFile().getConfiguration().set(key, null));
        this.kits.forEach(kit -> {
            String path = "kits." + kit.getName().replaceAll("\\s+", "") + ".";
            ArrayList<Value> values = new ArrayList<Value>();
            values.add(new Value("displayName", kit.getDisplayName()));
            values.add(new Value("items", ItemUtils.serialize(kit.getItems())));
            values.add(new Value("arenas", kit.getArenasAsString()));
            values.add(new Value("potionEffects", kit.getPotionsAsString()));
            values.add(new Value("icon", ItemUtils.serialize(kit.getIcon())));
            values.add(new Value("slot", kit.getSlot()));
            values.add(new Value("health", kit.getHealth()));
            values.add(new Value("kitEditor-slot", kit.getKitEditorSlot()));
            values.add(new Value("damage-multiplier", kit.getDamageMultiplier()));
            for (Map.Entry<KitRule, Boolean> kitRuleEntry : kit.getRules().entrySet()) {
                values.add(new Value(kitRuleEntry.getKey().getSaveName(), kit.is(kitRuleEntry.getKey())));
            }
            this.save(values, path);
        });
    }

    @Override
    public Kit getKitByName(String kitName) {
        for (Kit kit : this.kits) {
            if (!kit.getName().equalsIgnoreCase(kitName)) continue;
            return kit;
        }
        return null;
    }

    @Override
    public Kit getKitByDisplay(String kitName) {
        for (Kit kit : this.kits) {
            if (!kit.getDisplayName().equals(kitName)) continue;
            return kit;
        }
        return null;
    }

    public List<String> getKitNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Kit kit : this.kits) {
            names.add(kit.getName());
        }
        return names;
    }

    public void removeArenasFromKits(Arena arena) {
        for (Kit kit : this.kits) {
            kit.getArenas().remove(arena);
        }
    }

    @Override
    public void removeArena(IArena arena) {
        this.removeArenasFromKits((Arena)arena);
    }

    @Override
    public ConfigFile getConfigFile() {
        return ConfigService.get().getKitsConfig();
    }

    @Override
    public LinkedHashSet<IKit> getAllKits() {
        return new LinkedHashSet<IKit>(this.kits);
    }

    @Generated
    public LinkedHashSet<Kit> getKits() {
        return this.kits;
    }
}

