/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.kit.menu.button;

import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.KitService;
import dev.lrxh.neptune.game.kit.menu.KitManagementMenu;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.menu.Button;
import java.util.LinkedHashSet;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class KitSelectSlotButton
extends Button {
    private final Kit kit;
    private final LinkedHashSet<Kit> kits = KitService.get().getKits();

    public KitSelectSlotButton(int slot, Kit kit) {
        super(slot, false);
        this.kit = kit;
    }

    @Override
    public void onClick(ClickType type, Player player) {
        Optional<Kit> existingKit = this.kits.stream().filter(kit -> kit.getSlot() == this.getSlot()).findFirst();
        if (existingKit.isPresent()) {
            player.sendMessage((Component)CC.error("Select an unoccupied slot!"));
            return;
        }
        this.kit.setSlot(this.getSlot());
        new KitManagementMenu(this.kit).open(player);
        player.sendMessage((Component)CC.success("New slot set"));
    }

    @Override
    public ItemStack getItemStack(Player player) {
        Optional<Kit> existingKit = this.kits.stream().filter(kit -> kit.getSlot() == this.getSlot()).findFirst();
        if (existingKit.isPresent()) {
            ItemStack icon = existingKit.get().getIcon();
            ItemMeta meta = icon.getItemMeta();
            meta.displayName((Component)CC.color("&eSlot &6" + this.getSlot() + " &7(&f" + existingKit.get().getDisplayName() + "&7)"));
            icon.setItemMeta(meta);
            return new ItemBuilder(icon).build();
        }
        return new ItemBuilder(Material.getMaterial((String)MenusLocale.FILTER_MATERIAL.getString())).name("&eSlot &6" + this.getSlot()).build();
    }
}

