/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.kit.menu.editor.button;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.ItemBuilder;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.menu.Button;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class KitEditorSelectButton
extends Button {
    private final Kit kit;

    public KitEditorSelectButton(int slot, Kit kit) {
        super(slot);
        this.kit = kit;
    }

    @Override
    public void onClick(ClickType type, Player player) {
        Profile profile = API.getProfile(player);
        MessagesLocale.KIT_EDITOR_START.send(player.getUniqueId(), new Replacement("<kit>", this.kit.getDisplayName()));
        player.closeInventory();
        profile.getGameData().setKitEditor(this.kit);
        profile.setState(ProfileState.IN_KIT_EDITOR);
        this.kit.giveLoadout(player.getUniqueId());
        player.updateInventory();
    }

    @Override
    public ItemStack getItemStack(Player player) {
        return new ItemBuilder(this.kit.getIcon()).name(MenusLocale.KIT_EDITOR_SELECT_KIT_NAME.getString().replace("<kit>", this.kit.getDisplayName())).lore(ItemUtils.getLore(MenusLocale.KIT_EDITOR_SELECT_LORE.getStringList(), new Replacement("<kit>", this.kit.getDisplayName())), player).build();
    }
}

