/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match;

import dev.lrxh.api.events.MatchSpectatorAddEvent;
import dev.lrxh.api.events.MatchSpectatorRemoveEvent;
import dev.lrxh.api.match.IMatch;
import dev.lrxh.api.match.participant.IParticipant;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.configs.impl.ScoreboardLocale;
import dev.lrxh.neptune.feature.hotbar.HotbarService;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.ffa.FfaFightMatch;
import dev.lrxh.neptune.game.match.impl.participant.DeathCause;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.participant.ParticipantColor;
import dev.lrxh.neptune.game.match.impl.solo.SoloFightMatch;
import dev.lrxh.neptune.game.match.impl.team.TeamFightMatch;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.providers.placeholder.PlaceholderUtil;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.PlayerUtil;
import dev.lrxh.neptune.utils.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;

public abstract class Match
implements IMatch {
    public final List<UUID> spectators = new ArrayList<UUID>();
    private final UUID uuid = UUID.randomUUID();
    private final HashSet<Location> placedBlocks = new HashSet();
    private final HashMap<Location, BlockData> changes = new HashMap();
    private final Set<Location> liquids = new HashSet<Location>();
    private final HashSet<Entity> entities = new HashSet();
    private final Time time = new Time();
    private MatchState state;
    private Arena arena;
    private Kit kit;
    private List<Participant> participants;
    private int rounds;
    private boolean duel;
    private boolean ended;

    @Override
    public List<IParticipant> getParticipants() {
        return this.participants.stream().map(IParticipant.class::cast).toList();
    }

    public List<Participant> getParticipantsList() {
        return this.participants;
    }

    public void playSound(Sound sound) {
        this.forEachPlayer(player -> player.playSound(player.getLocation(), sound, 1.0f, 1.0f));
    }

    public Location getSpawn(Participant participant) {
        if (participant.getColor().equals(ParticipantColor.RED)) {
            return this.arena.getRedSpawn();
        }
        return this.arena.getBlueSpawn();
    }

    public Participant getParticipant(UUID playerUUID) {
        for (Participant participant : this.participants) {
            if (!participant.getPlayerUUID().equals(playerUUID)) continue;
            return participant;
        }
        return null;
    }

    @Override
    public Participant getParticipant(Player player) {
        for (Participant participant : this.participants) {
            if (!participant.getPlayerUUID().equals(player.getUniqueId())) continue;
            return participant;
        }
        return null;
    }

    public void sendTitle(TextComponent header, TextComponent footer, int duration) {
        this.forEachParticipant(participant -> PlayerUtil.sendTitle(participant.getPlayer(), header, footer, duration));
    }

    public void sendMessage(MessagesLocale message, Replacement ... replacements) {
        this.forEachParticipant(participant -> message.send(participant.getPlayerUUID(), replacements));
        this.forEachSpectator(player -> message.send(player.getUniqueId(), replacements));
    }

    public void addSpectator(Player player, Player target, boolean sendMessage, boolean add) {
        Profile profile = API.getProfile(player);
        profile.setState(ProfileState.IN_SPECTATOR);
        profile.setMatch(this);
        if (add) {
            this.spectators.add(player.getUniqueId());
        }
        this.showPlayerForSpectators();
        if (sendMessage) {
            this.broadcast(MessagesLocale.SPECTATE_START, new Replacement("<player>", player.getName()));
        }
        player.setHealth(20.0);
        player.setFoodLevel(20);
        player.setCollidable(false);
        player.teleportAsync(target.getLocation()).thenAccept(success -> {
            if (!success.booleanValue()) {
                return;
            }
            this.forEachPlayer(alivePlayer -> {
                if (!alivePlayer.equals((Object)player)) {
                    player.showPlayer((Plugin)Neptune.get(), alivePlayer);
                    alivePlayer.hidePlayer((Plugin)Neptune.get(), player);
                }
            });
            Bukkit.getScheduler().runTaskLater((Plugin)Neptune.get(), () -> {
                player.setAllowFlight(true);
                player.setFlying(true);
            }, 5L);
        });
        player.setGameMode(GameMode.SURVIVAL);
        player.setAllowFlight(true);
        player.setFlying(true);
        HotbarService.get().giveItems(player);
        MatchSpectatorAddEvent event = new MatchSpectatorAddEvent(this, player);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public void showPlayerForSpectators() {
        this.forEachSpectator(spectator -> this.forEachPlayer(alivePlayer -> {
            spectator.showPlayer((Plugin)Neptune.get(), alivePlayer);
            alivePlayer.hidePlayer((Plugin)Neptune.get(), spectator);
        }));
    }

    public void forEachPlayer(Consumer<Player> action) {
        for (Participant participant : this.participants) {
            Player player = participant.getPlayer();
            if (player == null) continue;
            action.accept(player);
        }
    }

    public void forEachSpectator(Consumer<Player> action) {
        for (UUID spectatorUUID : this.spectators) {
            Player player = Bukkit.getPlayer((UUID)spectatorUUID);
            if (player == null) continue;
            action.accept(player);
        }
    }

    public void forEachParticipant(Consumer<Participant> action) {
        for (Participant participant : this.participants) {
            Player player;
            if (participant.isDisconnected() || participant.isLeft() || (player = participant.getPlayer()) == null) continue;
            action.accept(participant);
        }
    }

    public void forEachParticipantForce(Consumer<Participant> action) {
        for (Participant participant : this.participants) {
            Player player = participant.getPlayer();
            if (player == null) continue;
            action.accept(participant);
        }
    }

    public void resetArena() {
        this.removeEntities();
        this.arena.restore();
    }

    public List<String> getScoreboard(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return new ArrayList<String>();
        }
        if (this instanceof SoloFightMatch) {
            MatchState matchState = this.getState();
            if (this.kit.is(KitRule.BEST_OF_THREE) && matchState.equals(MatchState.STARTING)) {
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BEST_OF.getStringList()), player);
            }
            switch (matchState) {
                case STARTING: {
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_STARTING.getStringList()), player);
                }
                case IN_ROUND: {
                    if (this.getRounds() > 1) {
                        return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BEST_OF.getStringList()), player);
                    }
                    if (this.getKit().is(KitRule.BOXING)) {
                        return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BOXING.getStringList()), player);
                    }
                    if (this.getKit().is(KitRule.BED_WARS)) {
                        return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BEDWARS.getStringList()), player);
                    }
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME.getStringList()), player);
                }
                case ENDING: {
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_ENDED.getStringList()), player);
                }
            }
        } else {
            if (this instanceof TeamFightMatch) {
                if (this.getKit().is(KitRule.BED_WARS)) {
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BEDWARS_TEAM.getStringList()), player);
                }
                if (this.getKit().is(KitRule.BOXING)) {
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BOXING_TEAM.getStringList()), player);
                }
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_TEAM.getStringList()), player);
            }
            if (this instanceof FfaFightMatch) {
                if (this.getKit().is(KitRule.BOXING)) {
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_BOXING_FFA.getStringList()), player);
                }
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_GAME_FFA.getStringList()), player);
            }
        }
        return null;
    }

    public void removeSpectator(UUID playerUUID, boolean sendMessage) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        Profile profile = API.getProfile(playerUUID);
        if (profile.getMatch() == null) {
            return;
        }
        PlayerUtil.reset(player);
        profile.setMatch(null);
        this.spectators.remove(playerUUID);
        PlayerUtil.teleportToSpawn(playerUUID);
        player.setCollidable(true);
        profile.setState(profile.getGameData().getParty() == null ? ProfileState.IN_LOBBY : ProfileState.IN_PARTY);
        if (sendMessage) {
            this.broadcast(MessagesLocale.SPECTATE_STOP, new Replacement("<player>", player.getName()));
        }
        MatchSpectatorRemoveEvent event = new MatchSpectatorRemoveEvent(this, player);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public void setupPlayer(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        Profile profile = API.getProfile(playerUUID);
        profile.setMatch(this);
        profile.setState(ProfileState.IN_GAME);
        PlayerUtil.reset(player);
        Participant participant = this.getParticipant(playerUUID);
        participant.setLastAttacker(null);
        this.kit.giveLoadout(participant);
        player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(this.kit.getHealth());
        player.setHealth(this.kit.getHealth());
        player.sendHealthUpdate();
    }

    public void broadcast(MessagesLocale messagesLocale, Replacement ... replacements) {
        this.forEachParticipant(participant -> messagesLocale.send(participant.getPlayerUUID(), replacements));
        this.forEachSpectator(player -> messagesLocale.send(player.getUniqueId(), replacements));
    }

    @Override
    public void broadcast(String message) {
        this.forEachParticipant(participant -> participant.sendMessage(CC.color(message)));
        this.forEachSpectator(player -> player.sendMessage((Component)CC.color(message)));
    }

    public void checkRules() {
        this.forEachParticipant(participant -> {
            if (!(this instanceof FfaFightMatch) && this.kit.is(KitRule.DENY_MOVEMENT)) {
                participant.toggleFreeze();
            }
            if (this.kit.is(KitRule.SHOW_HP) && this.state.equals(MatchState.STARTING)) {
                this.showHealth();
            }
            if (!this.kit.is(KitRule.SATURATION)) {
                Player player = participant.getPlayer();
                if (player == null) {
                    return;
                }
                player.setSaturation(0.0f);
            } else {
                Player player = participant.getPlayer();
                if (player == null) {
                    return;
                }
                player.setSaturation(20.0f);
            }
            participant.setDead(false);
        });
        this.showPlayerForSpectators();
    }

    public void hideHealth() {
        this.forEachPlayer(player -> {
            Objective objective = player.getScoreboard().getObjective(DisplaySlot.BELOW_NAME);
            if (objective != null) {
                objective.unregister();
            }
        });
    }

    public void hideParticipant(Participant participant) {
        this.forEachParticipant(p -> {
            if (!p.equals(participant)) {
                p.getPlayer().hidePlayer((Plugin)Neptune.get(), participant.getPlayer());
            }
        });
    }

    public void showParticipant(Participant participant) {
        this.forEachParticipant(p -> {
            if (!p.equals(participant)) {
                p.getPlayer().showPlayer((Plugin)Neptune.get(), participant.getPlayer());
            }
        });
    }

    private void showHealth() {
        this.forEachPlayer(player -> {
            Objective objective = player.getScoreboard().getObjective(DisplaySlot.BELOW_NAME);
            if (objective == null) {
                objective = player.getScoreboard().registerNewObjective("neptune_health", Criteria.HEALTH, (Component)CC.color("&c\u2764"));
            }
            try {
                objective.setDisplaySlot(DisplaySlot.BELOW_NAME);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            player.damage(0.001);
        });
    }

    public void removeEntities() {
        for (Entity entity : new HashSet<Entity>(this.entities)) {
            if (entity == null) continue;
            entity.remove();
            this.entities.remove(entity);
        }
    }

    public void setupParticipants() {
        this.forEachPlayer(player -> this.setupPlayer(player.getUniqueId()));
        this.forEachParticipant(par -> {
            par.reset();
            this.showParticipant((Participant)par);
        });
    }

    public void sendDeathMessage(Participant deadParticipant) {
        String deathMessage = deadParticipant.getDeathMessage();
        DeathCause deathCause = deadParticipant.getDeathCause();
        if (deathMessage.isEmpty() && deathCause != null) {
            this.broadcast(deadParticipant.getDeathCause().getMessage(), new Replacement("<player>", deadParticipant.getNameColored()), new Replacement("<killer>", deadParticipant.getLastAttackerName()));
        } else {
            this.broadcast(deathMessage);
        }
    }

    public void teleportToPositions() {
        for (Participant participant : this.participants) {
            this.teleportPlayerToPosition(participant);
        }
    }

    public void teleportPlayerToPosition(Participant participant) {
        Location location = participant.getColor().equals(ParticipantColor.RED) ? this.arena.getRedSpawn() : this.arena.getBlueSpawn();
        Player player = participant.getPlayer();
        if (player == null) {
            return;
        }
        player.teleport(location);
    }

    public abstract void win(Participant var1);

    public abstract void end(Participant var1);

    public abstract void onDeath(Participant var1);

    public abstract void onLeave(Participant var1, boolean var2);

    public abstract void startMatch();

    public abstract void sendEndMessage();

    public abstract void breakBed(Participant var1, Participant var2);

    public abstract void sendTitle(Participant var1, TextComponent var2, TextComponent var3, int var4);

    @Generated
    public Match(MatchState state, Arena arena, Kit kit, List<Participant> participants, int rounds, boolean duel, boolean ended) {
        this.state = state;
        this.arena = arena;
        this.kit = kit;
        this.participants = participants;
        this.rounds = rounds;
        this.duel = duel;
        this.ended = ended;
    }

    @Override
    @Generated
    public List<UUID> getSpectators() {
        return this.spectators;
    }

    @Override
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public HashSet<Location> getPlacedBlocks() {
        return this.placedBlocks;
    }

    @Generated
    public HashMap<Location, BlockData> getChanges() {
        return this.changes;
    }

    @Generated
    public Set<Location> getLiquids() {
        return this.liquids;
    }

    @Generated
    public HashSet<Entity> getEntities() {
        return this.entities;
    }

    @Generated
    public Time getTime() {
        return this.time;
    }

    @Override
    @Generated
    public MatchState getState() {
        return this.state;
    }

    @Override
    @Generated
    public Arena getArena() {
        return this.arena;
    }

    @Override
    @Generated
    public Kit getKit() {
        return this.kit;
    }

    @Override
    @Generated
    public int getRounds() {
        return this.rounds;
    }

    @Override
    @Generated
    public boolean isDuel() {
        return this.duel;
    }

    @Override
    @Generated
    public boolean isEnded() {
        return this.ended;
    }

    @Generated
    public void setState(MatchState state) {
        this.state = state;
    }

    @Generated
    public void setArena(Arena arena) {
        this.arena = arena;
    }

    @Generated
    public void setKit(Kit kit) {
        this.kit = kit;
    }

    @Generated
    public void setParticipants(List<Participant> participants) {
        this.participants = participants;
    }

    @Generated
    public void setRounds(int rounds) {
        this.rounds = rounds;
    }

    @Generated
    public void setDuel(boolean duel) {
        this.duel = duel;
    }

    @Generated
    public void setEnded(boolean ended) {
        this.ended = ended;
    }
}

