/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.impl.ffa;

import dev.lrxh.api.match.IFffaFightMatch;
import dev.lrxh.api.match.participant.IParticipant;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.participant.DeathCause;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.tasks.MatchEndRunnable;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Sound;

public class FfaFightMatch
extends Match
implements IFffaFightMatch {
    public final List<Participant> deadParticipants = new ArrayList<Participant>();
    private final List<Participant> participants;
    private Participant winner = null;

    public FfaFightMatch(Arena arena, Kit kit, List<Participant> participants) {
        super(MatchState.STARTING, arena, kit, participants, 1, true, false);
        this.participants = participants;
    }

    @Override
    public void win(Participant winner) {
        this.setState(MatchState.ENDING);
        this.winner = winner;
        this.setEnded(true);
        new MatchEndRunnable(this).start(0L, 20L);
    }

    @Override
    public void end(Participant loser) {
        this.setState(MatchState.ENDING);
        loser.setLoser(true);
        this.forEachParticipant(participant -> {
            if (this.winner == null) {
                return;
            }
            participant.sendTitle(CC.color(MessagesLocale.MATCH_WINNER_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_WINNER_TITLE_FOOTER.getString().replace("<player>", this.winner.getNameUnColored())), 100);
        });
        loser.playKillEffect();
        new MatchEndRunnable(this).start(0L, 20L);
    }

    @Override
    public void onDeath(Participant participant) {
        if (this.isEnded()) {
            return;
        }
        this.hideParticipant(participant);
        participant.setDead(true);
        participant.setLoser(true);
        Profile profile = API.getProfile(participant.getPlayerUUID());
        if (!participant.isLeft() && !participant.isDisconnected()) {
            this.addSpectator(participant.getPlayer(), participant.getPlayer(), false, false);
        } else {
            if (participant.getPlayer() != null) {
                PlayerUtil.reset(participant.getPlayer());
                PlayerUtil.teleportToSpawn(participant.getPlayerUUID());
            }
            if (profile != null) {
                profile.setState(profile.getGameData().getParty() == null ? ProfileState.IN_LOBBY : ProfileState.IN_PARTY);
                profile.setMatch(null);
            }
        }
        if (participant.getLastAttacker() != null) {
            participant.getLastAttacker().playSound(Sound.UI_BUTTON_CLICK);
        }
        this.sendDeathMessage(participant);
        this.deadParticipants.add(participant);
        if (!this.isLastPlayerStanding()) {
            return;
        }
        this.winner = this.getLastPlayerStanding();
        this.setEnded(true);
        this.end(participant);
    }

    private boolean isLastPlayerStanding() {
        return this.getParticipants().size() - this.deadParticipants.size() == 1;
    }

    private Participant getLastPlayerStanding() {
        for (IParticipant participant : this.getParticipants()) {
            if (this.deadParticipants.contains(participant)) continue;
            return (Participant)participant;
        }
        return null;
    }

    @Override
    public void onLeave(Participant participant, boolean quit) {
        if (this.isEnded()) {
            return;
        }
        participant.setDeathCause(DeathCause.DISCONNECT);
        Profile profile = API.getProfile(participant.getPlayerUUID());
        if (quit) {
            participant.setDisconnected(true);
        } else {
            participant.setLeft(true);
            PlayerUtil.reset(participant.getPlayer());
            PlayerUtil.teleportToSpawn(participant.getPlayerUUID());
            profile.setState(profile.getGameData().getParty() == null ? ProfileState.IN_LOBBY : ProfileState.IN_PARTY);
            profile.setMatch(null);
        }
        this.onDeath(participant);
    }

    @Override
    public void startMatch() {
        this.setState(MatchState.IN_ROUND);
        this.showPlayerForSpectators();
        this.playSound(Sound.ENTITY_FIREWORK_ROCKET_BLAST);
        this.sendTitle(CC.color(MessagesLocale.MATCH_START_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_START_TITLE_FOOTER.getString()), 20);
    }

    @Override
    public void sendEndMessage() {
        if (this.winner == null) {
            return;
        }
        this.forEachParticipant(participant -> MessagesLocale.MATCH_END_DETAILS_FFA.send(participant.getPlayerUUID(), new Replacement("<winner>", this.winner.getNameUnColored()), new Replacement("<kit>", this.getKit().getDisplayName())));
    }

    @Override
    public void breakBed(Participant participant, Participant breaker) {
    }

    @Override
    public void sendTitle(Participant participant, TextComponent header, TextComponent footer, int duration) {
        participant.sendTitle(header, footer, duration);
    }

    @Override
    public List<IParticipant> getParticipants() {
        return new ArrayList<IParticipant>(this.participants);
    }

    @Override
    public List<IParticipant> getDeadParticipants() {
        return new ArrayList<IParticipant>(this.deadParticipants);
    }

    @Override
    @Generated
    public Participant getWinner() {
        return this.winner;
    }
}

