/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.impl.participant;

import dev.lrxh.api.match.IMatch;
import dev.lrxh.api.match.participant.IParticipant;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.participant.DeathCause;
import dev.lrxh.neptune.game.match.impl.participant.ParticipantColor;
import dev.lrxh.neptune.game.match.impl.team.TeamFightMatch;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.PlayerUtil;
import dev.lrxh.neptune.utils.Time;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class Participant
implements IParticipant {
    public boolean dead = false;
    private UUID playerUUID;
    private String name;
    private Participant opponent;
    private DeathCause deathCause;
    private ParticipantColor color;
    private Participant lastAttacker;
    private int hits;
    private int longestCombo;
    private int combo;
    private boolean loser;
    private boolean disconnected = false;
    private boolean left = false;
    private int points = 0;
    private boolean frozen = false;
    private boolean bedBroken;
    private Time time;
    private int eloChange = 0;
    private Location currentCheckPoint;
    private int checkPoint = 0;

    public Participant(Player player) {
        this.playerUUID = player.getUniqueId();
        this.name = player.getName();
    }

    @Override
    public void reset() {
        this.bedBroken = false;
        this.currentCheckPoint = null;
        this.checkPoint = 0;
        this.hits = 0;
        this.combo = 0;
    }

    public void setDead(boolean dead) {
        this.dead = dead;
        this.playSound(Sound.BLOCK_NOTE_BLOCK_PLING);
    }

    public boolean setCurrentCheckPoint(Location location) {
        if (this.currentCheckPoint != null && location.getBlockX() == this.currentCheckPoint.getBlockX() && location.getBlockY() == this.currentCheckPoint.getBlockY() && location.getBlockZ() == this.currentCheckPoint.getBlockZ()) {
            return false;
        }
        this.currentCheckPoint = location.add(0.5, 0.0, 0.5);
        ++this.checkPoint;
        return true;
    }

    @Override
    public void toggleFreeze() {
        this.frozen = !this.frozen;
    }

    @Override
    public String getNameColored() {
        return this.color.getColor() + this.name;
    }

    @Override
    public void addWin() {
        ++this.points;
    }

    public String getNameUnColored() {
        return this.name;
    }

    public void playSound(Sound sound) {
        Player player = Bukkit.getPlayer((UUID)this.playerUUID);
        if (player == null) {
            return;
        }
        player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
    }

    public void teleport(Location location) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.teleport(location);
    }

    @Override
    public void playKillEffect() {
        Participant lastAttacker = this.getLastAttacker();
        if (lastAttacker == null) {
            return;
        }
        UUID attckerUUID = lastAttacker.getPlayerUUID();
        if (attckerUUID == null) {
            return;
        }
        Profile profile = API.getProfile(attckerUUID);
        Player player = this.getPlayer();
        Player killer = Bukkit.getPlayer((UUID)attckerUUID);
        if (profile == null || player == null || killer == null) {
            return;
        }
        profile.getSettingData().getKillEffect().execute(player, killer);
    }

    public Location getSpawn(Match match) {
        if (this.currentCheckPoint != null) {
            return this.currentCheckPoint;
        }
        return match.getSpawn(this);
    }

    @Override
    public Location getSpawn(IMatch match) {
        return this.getSpawn((Match)match);
    }

    @Override
    public Profile getProfile() {
        return API.getProfile(this.playerUUID);
    }

    public void sendTitle(TextComponent header, TextComponent footer, int duration) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerUtil.sendTitle(player, header, footer, duration);
    }

    public void sendTitle(MessagesLocale header, MessagesLocale footer, int duration) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        PlayerUtil.sendTitle(player, CC.color(header.getString()), CC.color(footer.getString()), duration);
    }

    public void sendMessage(TextComponent message) {
        PlayerUtil.sendMessage(this.playerUUID, (Component)message);
    }

    public void sendMessage(MessagesLocale message, Replacement ... replacements) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        message.send(player, replacements);
    }

    @Override
    public void resetCombo() {
        this.combo = 0;
    }

    public void handleHit(Participant opponent) {
        TeamFightMatch teamFightMatch;
        Match match;
        Participant lastAttacker = opponent.getLastAttacker();
        if (lastAttacker != null && !lastAttacker.equals(this)) {
            this.resetCombo();
        }
        ++this.hits;
        ++this.combo;
        if (this.combo > this.longestCombo) {
            this.longestCombo = this.combo;
        }
        if (MessagesLocale.MATCH_COMBO_MESSAGE_ENABLE.getBoolean()) {
            switch (this.combo) {
                case 5: {
                    MessagesLocale.MATCH_COMBO_MESSAGE_5.send(this.playerUUID, new Replacement[0]);
                    break;
                }
                case 10: {
                    MessagesLocale.MATCH_COMBO_MESSAGE_10.send(this.playerUUID, new Replacement[0]);
                    break;
                }
                case 20: {
                    MessagesLocale.MATCH_COMBO_MESSAGE_20.send(this.playerUUID, new Replacement[0]);
                }
            }
        }
        if ((match = API.getProfile(this.playerUUID).getMatch()).getKit().is(KitRule.BOXING) && (match instanceof TeamFightMatch ? this.hits >= (teamFightMatch = (TeamFightMatch)match).getTeamA().getParticipants().size() * 100 : this.hits >= 100)) {
            opponent.setDeathCause(this.getLastAttacker() != null ? DeathCause.KILL : DeathCause.DIED);
            match.onDeath(opponent);
        }
    }

    public String getHitsDifference(Participant otherParticipant) {
        if (this.hits - otherParticipant.getHits() > 0) {
            return "&a(+" + (this.hits - otherParticipant.getHits()) + ")";
        }
        if (this.hits - otherParticipant.getHits() < 0) {
            return "&c(" + (this.hits - otherParticipant.getHits()) + ")";
        }
        return "&e(" + (this.hits - otherParticipant.getHits()) + ")";
    }

    @Override
    public String getHitsDifference(IParticipant otherParticipant) {
        if (this.hits - otherParticipant.getHits() > 0) {
            return "&a(+" + (this.hits - otherParticipant.getHits()) + ")";
        }
        if (this.hits - otherParticipant.getHits() < 0) {
            return "&c(" + (this.hits - otherParticipant.getHits()) + ")";
        }
        return "&e(" + (this.hits - otherParticipant.getHits()) + ")";
    }

    @Override
    public String getHitsDifferenceUncolored(IParticipant otherParticipant) {
        if (this.hits - otherParticipant.getHits() > 0) {
            return "+" + (this.hits - otherParticipant.getHits());
        }
        if (this.hits - otherParticipant.getHits() < 0) {
            return String.valueOf(this.hits - otherParticipant.getHits());
        }
        return "-" + (this.hits - otherParticipant.getHits());
    }

    public String getDeathMessage() {
        Profile profile = API.getProfile(this.playerUUID);
        if (profile == null) {
            return "";
        }
        Match match = profile.getMatch();
        if (match == null) {
            return "";
        }
        Participant lastAttacker = this.getLastAttacker();
        if (lastAttacker == null) {
            return "";
        }
        Profile attackerProfile = API.getProfile(lastAttacker.getPlayerUUID());
        if (attackerProfile == null || attackerProfile.getSettingData().getKillMessagePackage() == null) {
            return "";
        }
        return attackerProfile.getSettingData().getKillMessagePackage().getRandomMessage().replace("<player>", this.getNameColored()).replace("<killer>", this.getLastAttackerName());
    }

    public String getLastAttackerName() {
        return Optional.ofNullable(this.getLastAttacker()).map(Participant::getNameColored).orElse("");
    }

    public Player getPlayer() {
        Player p = Bukkit.getPlayer((UUID)this.playerUUID);
        if (p != null) {
            return p;
        }
        return Bukkit.getPlayer((String)this.getName());
    }

    @Override
    @Generated
    public boolean isDead() {
        return this.dead;
    }

    @Override
    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public Participant getOpponent() {
        return this.opponent;
    }

    @Generated
    public DeathCause getDeathCause() {
        return this.deathCause;
    }

    @Override
    @Generated
    public ParticipantColor getColor() {
        return this.color;
    }

    @Override
    @Generated
    public Participant getLastAttacker() {
        return this.lastAttacker;
    }

    @Override
    @Generated
    public int getHits() {
        return this.hits;
    }

    @Override
    @Generated
    public int getLongestCombo() {
        return this.longestCombo;
    }

    @Override
    @Generated
    public int getCombo() {
        return this.combo;
    }

    @Override
    @Generated
    public boolean isLoser() {
        return this.loser;
    }

    @Override
    @Generated
    public boolean isDisconnected() {
        return this.disconnected;
    }

    @Override
    @Generated
    public boolean isLeft() {
        return this.left;
    }

    @Override
    @Generated
    public int getPoints() {
        return this.points;
    }

    @Override
    @Generated
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    @Generated
    public boolean isBedBroken() {
        return this.bedBroken;
    }

    @Override
    @Generated
    public Time getTime() {
        return this.time;
    }

    @Override
    @Generated
    public int getEloChange() {
        return this.eloChange;
    }

    @Override
    @Generated
    public Location getCurrentCheckPoint() {
        return this.currentCheckPoint;
    }

    @Override
    @Generated
    public int getCheckPoint() {
        return this.checkPoint;
    }

    @Generated
    public void setPlayerUUID(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setOpponent(Participant opponent) {
        this.opponent = opponent;
    }

    @Generated
    public void setDeathCause(DeathCause deathCause) {
        this.deathCause = deathCause;
    }

    @Generated
    public void setColor(ParticipantColor color) {
        this.color = color;
    }

    @Generated
    public void setLastAttacker(Participant lastAttacker) {
        this.lastAttacker = lastAttacker;
    }

    @Generated
    public void setHits(int hits) {
        this.hits = hits;
    }

    @Generated
    public void setLongestCombo(int longestCombo) {
        this.longestCombo = longestCombo;
    }

    @Generated
    public void setCombo(int combo) {
        this.combo = combo;
    }

    @Generated
    public void setLoser(boolean loser) {
        this.loser = loser;
    }

    @Generated
    public void setDisconnected(boolean disconnected) {
        this.disconnected = disconnected;
    }

    @Generated
    public void setLeft(boolean left) {
        this.left = left;
    }

    @Generated
    public void setPoints(int points) {
        this.points = points;
    }

    @Generated
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Generated
    public void setBedBroken(boolean bedBroken) {
        this.bedBroken = bedBroken;
    }

    @Generated
    public void setTime(Time time) {
        this.time = time;
    }

    @Generated
    public void setEloChange(int eloChange) {
        this.eloChange = eloChange;
    }

    @Generated
    public void setCheckPoint(int checkPoint) {
        this.checkPoint = checkPoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Participant)) {
            return false;
        }
        Participant other = (Participant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDead() != other.isDead()) {
            return false;
        }
        if (this.getHits() != other.getHits()) {
            return false;
        }
        if (this.getLongestCombo() != other.getLongestCombo()) {
            return false;
        }
        if (this.getCombo() != other.getCombo()) {
            return false;
        }
        if (this.isLoser() != other.isLoser()) {
            return false;
        }
        if (this.isDisconnected() != other.isDisconnected()) {
            return false;
        }
        if (this.isLeft() != other.isLeft()) {
            return false;
        }
        if (this.getPoints() != other.getPoints()) {
            return false;
        }
        if (this.isFrozen() != other.isFrozen()) {
            return false;
        }
        if (this.isBedBroken() != other.isBedBroken()) {
            return false;
        }
        if (this.getEloChange() != other.getEloChange()) {
            return false;
        }
        if (this.getCheckPoint() != other.getCheckPoint()) {
            return false;
        }
        UUID this$playerUUID = this.getPlayerUUID();
        UUID other$playerUUID = other.getPlayerUUID();
        if (this$playerUUID == null ? other$playerUUID != null : !((Object)this$playerUUID).equals(other$playerUUID)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Participant this$opponent = this.getOpponent();
        Participant other$opponent = other.getOpponent();
        if (this$opponent == null ? other$opponent != null : !((Object)this$opponent).equals(other$opponent)) {
            return false;
        }
        DeathCause this$deathCause = this.getDeathCause();
        DeathCause other$deathCause = other.getDeathCause();
        if (this$deathCause == null ? other$deathCause != null : !((Object)((Object)this$deathCause)).equals((Object)other$deathCause)) {
            return false;
        }
        ParticipantColor this$color = this.getColor();
        ParticipantColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        Participant this$lastAttacker = this.getLastAttacker();
        Participant other$lastAttacker = other.getLastAttacker();
        if (this$lastAttacker == null ? other$lastAttacker != null : !((Object)this$lastAttacker).equals(other$lastAttacker)) {
            return false;
        }
        Time this$time = this.getTime();
        Time other$time = other.getTime();
        if (this$time == null ? other$time != null : !this$time.equals(other$time)) {
            return false;
        }
        Location this$currentCheckPoint = this.getCurrentCheckPoint();
        Location other$currentCheckPoint = other.getCurrentCheckPoint();
        return !(this$currentCheckPoint == null ? other$currentCheckPoint != null : !this$currentCheckPoint.equals(other$currentCheckPoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Participant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDead() ? 79 : 97);
        result = result * 59 + this.getHits();
        result = result * 59 + this.getLongestCombo();
        result = result * 59 + this.getCombo();
        result = result * 59 + (this.isLoser() ? 79 : 97);
        result = result * 59 + (this.isDisconnected() ? 79 : 97);
        result = result * 59 + (this.isLeft() ? 79 : 97);
        result = result * 59 + this.getPoints();
        result = result * 59 + (this.isFrozen() ? 79 : 97);
        result = result * 59 + (this.isBedBroken() ? 79 : 97);
        result = result * 59 + this.getEloChange();
        result = result * 59 + this.getCheckPoint();
        UUID $playerUUID = this.getPlayerUUID();
        result = result * 59 + ($playerUUID == null ? 43 : ((Object)$playerUUID).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Participant $opponent = this.getOpponent();
        result = result * 59 + ($opponent == null ? 43 : ((Object)$opponent).hashCode());
        DeathCause $deathCause = this.getDeathCause();
        result = result * 59 + ($deathCause == null ? 43 : ((Object)((Object)$deathCause)).hashCode());
        ParticipantColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        Participant $lastAttacker = this.getLastAttacker();
        result = result * 59 + ($lastAttacker == null ? 43 : ((Object)$lastAttacker).hashCode());
        Time $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : $time.hashCode());
        Location $currentCheckPoint = this.getCurrentCheckPoint();
        result = result * 59 + ($currentCheckPoint == null ? 43 : $currentCheckPoint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Participant(dead=" + this.isDead() + ", playerUUID=" + String.valueOf(this.getPlayerUUID()) + ", name=" + this.getName() + ", opponent=" + String.valueOf(this.getOpponent()) + ", deathCause=" + String.valueOf((Object)this.getDeathCause()) + ", color=" + String.valueOf(this.getColor()) + ", lastAttacker=" + String.valueOf(this.getLastAttacker()) + ", hits=" + this.getHits() + ", longestCombo=" + this.getLongestCombo() + ", combo=" + this.getCombo() + ", loser=" + this.isLoser() + ", disconnected=" + this.isDisconnected() + ", left=" + this.isLeft() + ", points=" + this.getPoints() + ", frozen=" + this.isFrozen() + ", bedBroken=" + this.isBedBroken() + ", time=" + String.valueOf(this.getTime()) + ", eloChange=" + this.getEloChange() + ", currentCheckPoint=" + String.valueOf(this.getCurrentCheckPoint()) + ", checkPoint=" + this.getCheckPoint() + ")";
    }
}

