/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.impl.solo;

import dev.lrxh.api.events.SoloMatchBedDestroyEvent;
import dev.lrxh.api.match.ISoloFightMatch;
import dev.lrxh.api.match.participant.IParticipant;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.feature.hotbar.HotbarService;
import dev.lrxh.neptune.feature.leaderboard.LeaderboardService;
import dev.lrxh.neptune.feature.leaderboard.impl.LeaderboardPlayerEntry;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.participant.DeathCause;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.participant.ParticipantColor;
import dev.lrxh.neptune.game.match.tasks.MatchEndRunnable;
import dev.lrxh.neptune.game.match.tasks.MatchRespawnRunnable;
import dev.lrxh.neptune.game.match.tasks.MatchSecondRoundRunnable;
import dev.lrxh.neptune.profile.data.GameData;
import dev.lrxh.neptune.profile.data.MatchHistory;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.ClickableComponent;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.DateUtils;
import dev.lrxh.neptune.utils.PlayerUtil;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class SoloFightMatch
extends Match
implements ISoloFightMatch {
    private final Participant participantA;
    private final Participant participantB;

    public SoloFightMatch(Arena arena, Kit kit, boolean duel, List<Participant> participants, Participant participantA, Participant participantB, int rounds) {
        super(MatchState.STARTING, arena, kit, participants, rounds, duel, false);
        this.participantA = participantA;
        this.participantB = participantB;
    }

    @Override
    public void win(Participant winner) {
        Participant loser = this.participantA == winner ? this.participantB : this.participantA;
        this.setState(MatchState.ENDING);
        loser.setLoser(true);
        this.removePlaying();
        new MatchEndRunnable(this).start(0L, 20L);
    }

    @Override
    public void end(Participant loser) {
        this.setState(MatchState.ENDING);
        loser.setLoser(true);
        Participant winner = this.getWinner();
        winner.sendTitle(CC.color(MessagesLocale.MATCH_WINNER_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_WINNER_TITLE_FOOTER.getString().replace("<player>", MessagesLocale.MATCH_YOU.getString())), 100);
        if (!loser.isLeft() && !loser.isDisconnected()) {
            loser.sendTitle(CC.color(MessagesLocale.MATCH_LOSER_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_LOSER_TITLE_FOOTER.getString().replace("<player>", winner.getNameUnColored())), 100);
        }
        if (!this.isDuel()) {
            this.addStats();
            for (String command : SettingsLocale.COMMANDS_AFTER_MATCH_LOSER.getStringList()) {
                if (command.equals("NONE")) continue;
                command = command.replace("<player>", loser.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
            for (String command : SettingsLocale.COMMANDS_AFTER_MATCH_WINNER.getStringList()) {
                if (command.equals("NONE")) continue;
                command = command.replace("<player>", winner.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
            this.forEachPlayer(player -> HotbarService.get().giveItems((Player)player));
        }
        this.removePlaying();
        new MatchEndRunnable(this).start(0L, 20L);
    }

    private void removePlaying() {
        this.getParticipants().forEach(i -> this.getKit().removePlaying());
    }

    public void addStats() {
        Participant winner = this.getWinner();
        Participant loser = this.getLoser();
        Profile winnerProfile = API.getProfile(winner.getPlayerUUID());
        Profile loserProfile = API.getProfile(loser.getPlayerUUID());
        String kitName = this.getKit().getDisplayName();
        String arenaName = this.getArena().getDisplayName();
        String date = DateUtils.getDate();
        String time = LocalDateTime.now().atOffset(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        winnerProfile.getGameData().addHistory(new MatchHistory(true, loserProfile.getUsername(), kitName, arenaName, date, time));
        loserProfile.getGameData().addHistory(new MatchHistory(false, winnerProfile.getUsername(), kitName, arenaName, date, time));
        GameData winnerData = winnerProfile.getGameData();
        GameData loserData = loserProfile.getGameData();
        int initialWinnerElo = winnerData.get(this.getKit()).getElo();
        int initialLoserElo = loserData.get(this.getKit()).getElo();
        boolean rankedUp = winnerData.run(this.getKit(), true);
        loserData.run(this.getKit(), false);
        winner.setEloChange(winnerData.get(this.getKit()).getElo() - initialWinnerElo);
        loser.setEloChange(loserData.get(this.getKit()).getElo() - initialLoserElo);
        if (rankedUp) {
            String divisionName = winnerData.get(this.getKit()).getDivision().getDisplayName();
            winner.sendTitle(CC.color(MessagesLocale.RANKUP_TITLE_HEADER.getString().replace("<division>", divisionName)), CC.color(MessagesLocale.RANKUP_TITLE_FOOTER.getString().replace("<division>", divisionName)), 40);
            winner.sendMessage(MessagesLocale.RANKUP_MESSAGE, new Replacement("<division>", divisionName));
        }
        this.forEachParticipantForce(participant -> LeaderboardService.get().addChange(new LeaderboardPlayerEntry(participant.getNameUnColored(), participant.getPlayerUUID(), this.getKit())));
        if (winnerProfile.isFake()) {
            Profile.save(winnerProfile);
        }
        if (loserProfile.isFake()) {
            Profile.save(loserProfile);
        }
    }

    @Override
    public Participant getLoser() {
        return this.participantA.isLoser() ? this.participantA : this.participantB;
    }

    @Override
    public Participant getWinner() {
        return this.participantA.isLoser() ? this.participantB : this.participantA;
    }

    @Override
    public void sendEndMessage() {
        Participant winner = this.getWinner();
        Participant loser = this.getLoser();
        ArrayList<Replacement> replacements = new ArrayList<Replacement>(List.of(new Replacement("<loser>", loser.getNameUnColored()), new Replacement("<kit>", this.getKit().getDisplayName()), new Replacement("<winner_points>", String.valueOf(winner.getPoints())), new Replacement("<loser_points>", String.valueOf(loser.getPoints())), new Replacement("<winner>", winner.getNameUnColored())));
        if (!this.isDuel()) {
            replacements.add(new Replacement("<winner-elo>", String.valueOf(winner.getEloChange())));
            replacements.add(new Replacement("<loser-elo>", String.valueOf(loser.getEloChange())));
            this.broadcast(MessagesLocale.MATCH_END_DETAILS_SOLO, replacements.toArray(new Replacement[0]));
        } else {
            this.broadcast(MessagesLocale.MATCH_END_DETAILS_DUEL, replacements.toArray(new Replacement[0]));
        }
        this.forEachParticipant(participant -> {
            if (MessagesLocale.MATCH_PLAY_AGAIN_ENABLED.getBoolean()) {
                TextComponent playMessage = new ClickableComponent(MessagesLocale.MATCH_PLAY_AGAIN.getString(), "/queue " + this.getKit().getName(), MessagesLocale.MATCH_PLAY_AGAIN_HOVER.getString()).build();
                PlayerUtil.sendMessage(participant.getPlayerUUID(), (Component)playMessage);
            }
        });
    }

    @Override
    public void breakBed(Participant participant, Participant breaker) {
        participant.setBedBroken(true);
        this.playSound(Sound.ENTITY_ENDER_DRAGON_GROWL);
        SoloMatchBedDestroyEvent event = new SoloMatchBedDestroyEvent(this, participant, breaker);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Override
    public void sendTitle(Participant participant, TextComponent header, TextComponent footer, int duration) {
        participant.sendTitle(header, footer, duration);
    }

    @Override
    public void onDeath(Participant participant) {
        if (this.isEnded()) {
            return;
        }
        this.hideParticipant(participant);
        participant.setDead(true);
        this.playSound(Sound.ENTITY_PLAYER_ATTACK_STRONG);
        Participant participantKiller = this.participantA.getNameColored().equals(participant.getNameColored()) ? this.participantB : this.participantA;
        this.sendDeathMessage(participant);
        if (!participant.isDisconnected() && !participant.isLeft()) {
            if (this.getKit().is(KitRule.BED_WARS) && !participant.isBedBroken()) {
                participantKiller.setCombo(0);
                new MatchRespawnRunnable(this, participant).start(0L, 20L);
                return;
            }
            if (this.getRounds() > 1) {
                participantKiller.addWin();
                if (participantKiller.getPoints() < this.getRounds()) {
                    participantKiller.setCombo(0);
                    this.setState(MatchState.STARTING);
                    new MatchSecondRoundRunnable(this, participant).start(0L, 20L);
                    return;
                }
            }
        }
        if (participant.getLastAttacker() != null) {
            participant.getLastAttacker().playSound(Sound.UI_BUTTON_CLICK);
        }
        this.setEnded(true);
        participant.playKillEffect();
        PlayerUtil.doVelocityChange(participant.getPlayerUUID());
        if (!(participant.isDisconnected() || participant.isLeft() || this.isEnded())) {
            Participant otherParticipant;
            Participant participant2 = otherParticipant = this.participantA.equals(participant) ? this.participantB : this.participantA;
            if (otherParticipant.getPlayer() != null) {
                this.addSpectator(participant.getPlayer(), otherParticipant.getPlayer(), false, false);
            }
        }
        this.end(participant);
    }

    @Override
    public void onLeave(Participant participant, boolean quit) {
        if (this.isEnded()) {
            return;
        }
        participant.setDeathCause(DeathCause.DISCONNECT);
        this.sendDeathMessage(participant);
        this.setEnded(true);
        if (quit) {
            participant.setDisconnected(true);
        } else {
            participant.setLeft(true);
            PlayerUtil.reset(participant.getPlayer());
            PlayerUtil.teleportToSpawn(participant.getPlayerUUID());
            Profile profile = API.getProfile(participant.getPlayerUUID());
            profile.setState(profile.getGameData().getParty() == null ? ProfileState.IN_LOBBY : ProfileState.IN_PARTY);
            profile.setMatch(null);
        }
        this.end(participant);
    }

    @Override
    public void startMatch() {
        this.setState(MatchState.IN_ROUND);
        this.showPlayerForSpectators();
        this.playSound(Sound.ENTITY_FIREWORK_ROCKET_BLAST);
        this.sendTitle(CC.color(MessagesLocale.MATCH_START_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_START_TITLE_FOOTER.getString()), 20);
    }

    @Override
    public List<IParticipant> getParticipants() {
        return List.of(this.participantA, this.participantB);
    }

    @Override
    public Participant getRedParticipant() {
        return this.participantA.getColor().equals(ParticipantColor.RED) ? this.participantA : this.participantB;
    }

    @Override
    public Participant getBlueParticipant() {
        return this.participantA.getColor().equals(ParticipantColor.BLUE) ? this.participantA : this.participantB;
    }

    @Generated
    public Participant getParticipantA() {
        return this.participantA;
    }

    @Generated
    public Participant getParticipantB() {
        return this.participantB;
    }
}

