/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.impl.team;

import dev.lrxh.api.match.participant.IParticipant;
import dev.lrxh.api.match.team.IMatchTeam;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;

public class MatchTeam
implements IMatchTeam {
    private final List<Participant> participants;
    private final List<Participant> deadParticipants;
    private MatchTeam opponentTeam;
    private boolean bedBroken;
    private int points;

    public MatchTeam(List<Participant> participants) {
        this.participants = participants;
        this.deadParticipants = new ArrayList<Participant>();
    }

    @Override
    public List<IParticipant> getParticipants() {
        return this.participants.stream().map(p -> p).toList();
    }

    @Override
    public List<IParticipant> getDeadParticipants() {
        return this.deadParticipants.stream().map(p -> p).toList();
    }

    public List<Participant> deadParticipants() {
        return this.deadParticipants;
    }

    public List<Participant> participants() {
        return this.participants;
    }

    public void setBedBroken(boolean bedBroken) {
        this.bedBroken = bedBroken;
        this.forEachParticipant(participants -> participants.setBedBroken(bedBroken));
    }

    @Override
    public boolean isLoser() {
        return this.deadParticipants.size() >= this.participants.size();
    }

    public int getAliveParticipants() {
        return this.participants.size() - this.deadParticipants.size();
    }

    public void sendTitle(TextComponent header, TextComponent footer, int duration) {
        this.forEachParticipant(participant -> participant.sendTitle(header, footer, duration));
    }

    @Override
    public String getTeamNames() {
        StringBuilder playerNames = new StringBuilder();
        for (Participant participant : this.participants) {
            if (!playerNames.isEmpty()) {
                playerNames.append(MessagesLocale.MATCH_COMMA.getString());
            }
            playerNames.append(participant.getNameUnColored());
        }
        return playerNames.toString();
    }

    public void forEachParticipant(Consumer<Participant> action) {
        for (Participant participant : this.participants) {
            Player player = participant.getPlayer();
            if (player == null || participant.isLeft() || participant.isDisconnected()) continue;
            action.accept(participant);
        }
    }

    @Override
    public void addPoint() {
        ++this.points;
        this.forEachParticipant(Participant::addWin);
    }

    @Override
    @Generated
    public MatchTeam getOpponentTeam() {
        return this.opponentTeam;
    }

    @Generated
    public boolean isBedBroken() {
        return this.bedBroken;
    }

    @Override
    @Generated
    public int getPoints() {
        return this.points;
    }

    @Generated
    public void setOpponentTeam(MatchTeam opponentTeam) {
        this.opponentTeam = opponentTeam;
    }

    @Override
    @Generated
    public void setPoints(int points) {
        this.points = points;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchTeam)) {
            return false;
        }
        MatchTeam other = (MatchTeam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBedBroken() != other.isBedBroken()) {
            return false;
        }
        if (this.getPoints() != other.getPoints()) {
            return false;
        }
        List<IParticipant> this$participants = this.getParticipants();
        List<IParticipant> other$participants = other.getParticipants();
        if (this$participants == null ? other$participants != null : !((Object)this$participants).equals(other$participants)) {
            return false;
        }
        List<IParticipant> this$deadParticipants = this.getDeadParticipants();
        List<IParticipant> other$deadParticipants = other.getDeadParticipants();
        if (this$deadParticipants == null ? other$deadParticipants != null : !((Object)this$deadParticipants).equals(other$deadParticipants)) {
            return false;
        }
        MatchTeam this$opponentTeam = this.getOpponentTeam();
        MatchTeam other$opponentTeam = other.getOpponentTeam();
        return !(this$opponentTeam == null ? other$opponentTeam != null : !((Object)this$opponentTeam).equals(other$opponentTeam));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MatchTeam;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBedBroken() ? 79 : 97);
        result = result * 59 + this.getPoints();
        List<IParticipant> $participants = this.getParticipants();
        result = result * 59 + ($participants == null ? 43 : ((Object)$participants).hashCode());
        List<IParticipant> $deadParticipants = this.getDeadParticipants();
        result = result * 59 + ($deadParticipants == null ? 43 : ((Object)$deadParticipants).hashCode());
        MatchTeam $opponentTeam = this.getOpponentTeam();
        result = result * 59 + ($opponentTeam == null ? 43 : ((Object)$opponentTeam).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MatchTeam(participants=" + String.valueOf(this.getParticipants()) + ", deadParticipants=" + String.valueOf(this.getDeadParticipants()) + ", opponentTeam=" + String.valueOf(this.getOpponentTeam()) + ", bedBroken=" + this.isBedBroken() + ", points=" + this.getPoints() + ")";
    }
}

