/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.impl.team;

import dev.lrxh.api.events.TeamMatchBedDestroyEvent;
import dev.lrxh.api.match.ITeamFightMatch;
import dev.lrxh.api.match.participant.IParticipant;
import dev.lrxh.api.match.team.IMatchTeam;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.participant.DeathCause;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.team.MatchTeam;
import dev.lrxh.neptune.game.match.tasks.MatchEndRunnable;
import dev.lrxh.neptune.game.match.tasks.MatchRespawnRunnable;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.PlayerUtil;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.event.Event;

public class TeamFightMatch
extends Match
implements ITeamFightMatch {
    private final MatchTeam teamA;
    private final MatchTeam teamB;

    public TeamFightMatch(Arena arena, Kit kit, List<Participant> participants, MatchTeam teamA, MatchTeam teamB) {
        super(MatchState.STARTING, arena, kit, participants, 1, true, false);
        this.teamA = teamA;
        this.teamB = teamB;
    }

    public MatchTeam getParticipantTeam(Participant participant) {
        return this.teamA.participants().contains(participant) ? this.teamA : this.teamB;
    }

    @Override
    public IMatchTeam getParticipantTeam(IParticipant participant) {
        return this.getParticipantTeam((Participant)participant);
    }

    @Override
    public IMatchTeam getWinner() {
        return this.teamA.isLoser() ? this.teamB : this.teamA;
    }

    @Override
    public IMatchTeam getLoser() {
        return this.teamA.isLoser() ? this.teamA : this.teamB;
    }

    @Override
    public void win(Participant winner) {
        this.setState(MatchState.ENDING);
        new MatchEndRunnable(this).start(0L, 20L);
    }

    @Override
    public void end(Participant loser) {
        this.setState(MatchState.ENDING);
        MatchTeam winnerTeam = this.teamA.isLoser() ? this.teamB : this.teamA;
        MatchTeam loserTeam = this.getParticipantTeam(loser);
        winnerTeam.sendTitle(CC.color(MessagesLocale.MATCH_WINNER_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_WINNER_TITLE_FOOTER.getString().replace("<player>", MessagesLocale.MATCH_YOU.getString())), 100);
        loserTeam.sendTitle(CC.color(MessagesLocale.MATCH_LOSER_TITLE_HEADER.getString()), CC.color(MessagesLocale.MATCH_LOSER_TITLE_FOOTER.getString().replace("<player>", MessagesLocale.MATCH_OPPONENT_TEAM.getString())), 100);
        loser.playKillEffect();
        new MatchEndRunnable(this).start(0L, 20L);
    }

    @Override
    public void sendEndMessage() {
        MatchTeam winnerTeam = this.teamA.isLoser() ? this.teamB : this.teamA;
        MatchTeam loserTeam = this.teamA.isLoser() ? this.teamA : this.teamB;
        this.forEachParticipant(participant -> MessagesLocale.MATCH_END_DETAILS_TEAM.send(participant.getPlayerUUID(), new Replacement("<losers>", loserTeam.getTeamNames()), new Replacement("<kit>", this.getKit().getDisplayName()), new Replacement("<winners_points>", String.valueOf(winnerTeam.getPoints())), new Replacement("<losers_points>", String.valueOf(loserTeam.getPoints())), new Replacement("<winners>", winnerTeam.getTeamNames())));
    }

    @Override
    public void breakBed(Participant participant, Participant breaker) {
        MatchTeam team = this.getParticipantTeam(participant);
        team.setBedBroken(true);
        this.playSound(Sound.ENTITY_ENDER_DRAGON_GROWL);
        TeamMatchBedDestroyEvent event = new TeamMatchBedDestroyEvent(this, team, breaker);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Override
    public void sendTitle(Participant participant, TextComponent header, TextComponent footer, int duration) {
        this.getParticipantTeam(participant).sendTitle(header, footer, duration);
    }

    @Override
    public void onDeath(Participant participant) {
        boolean allOut;
        if (this.isEnded()) {
            return;
        }
        this.hideParticipant(participant);
        participant.setDead(true);
        MatchTeam team = this.getParticipantTeam(participant);
        team.deadParticipants().add(participant);
        if (!participant.isDisconnected() && !participant.isLeft()) {
            if (this.getKit().is(KitRule.BED_WARS) && !participant.isBedBroken()) {
                new MatchRespawnRunnable(this, participant).start(0L, 20L);
                return;
            }
            this.addSpectator(participant.getPlayer(), participant.getPlayer(), false, false);
            if (participant.getLastAttacker() != null) {
                participant.getLastAttacker().playSound(Sound.UI_BUTTON_CLICK);
            }
            this.sendDeathMessage(participant);
        }
        if (allOut = team.participants().stream().allMatch(p -> p.isDead() || p.isDisconnected() || p.isLeft())) {
            this.setEnded(true);
            PlayerUtil.doVelocityChange(participant.getPlayerUUID());
            this.end(participant);
        }
    }

    @Override
    public boolean onSameTeam(UUID playerUUID, UUID otherUUID) {
        Participant participant = this.getParticipant(playerUUID);
        Participant other = this.getParticipant(otherUUID);
        return this.getParticipantTeam(participant).equals(this.getParticipantTeam(other));
    }

    @Override
    public void onLeave(Participant participant, boolean quit) {
        if (this.isEnded()) {
            return;
        }
        participant.setDeathCause(DeathCause.DISCONNECT);
        this.sendDeathMessage(participant);
        if (quit) {
            participant.setDisconnected(true);
        } else {
            participant.setLeft(true);
            PlayerUtil.reset(participant.getPlayer());
            PlayerUtil.teleportToSpawn(participant.getPlayerUUID());
            Profile profile = API.getProfile(participant.getPlayerUUID());
            profile.setState(profile.getGameData().getParty() == null ? ProfileState.IN_LOBBY : ProfileState.IN_PARTY);
            profile.setMatch(null);
        }
        this.onDeath(participant);
    }

    @Override
    public void startMatch() {
        this.setState(MatchState.IN_ROUND);
        this.showPlayerForSpectators();
        this.playSound(Sound.ENTITY_FIREWORK_ROCKET_BLAST);
        this.sendTitle(CC.color(MessagesLocale.MATCH_START_TITLE_FOOTER.getString()), CC.color(MessagesLocale.MATCH_START_TITLE_FOOTER.getString()), 10);
    }

    @Override
    @Generated
    public MatchTeam getTeamA() {
        return this.teamA;
    }

    @Override
    @Generated
    public MatchTeam getTeamB() {
        return this.teamB;
    }
}

