/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.listener;

import dev.lrxh.api.events.MatchParticipantDeathEvent;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.game.arena.Arena;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.participant.DeathCause;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.participant.ParticipantColor;
import dev.lrxh.neptune.game.match.impl.team.TeamFightMatch;
import dev.lrxh.neptune.profile.ProfileService;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.EntityUtils;
import dev.lrxh.neptune.utils.LocationUtil;
import dev.lrxh.neptune.utils.WorldUtils;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import io.papermc.paper.event.block.BlockBreakBlockEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.WindCharge;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class MatchListener
implements Listener {
    private final NamespacedKey explosiveOwnerKey = new NamespacedKey((Plugin)Neptune.get(), "neptune_explosive_owner");

    private boolean isPlayerInMatch(Profile profile) {
        if (profile == null) {
            return false;
        }
        return profile.getState().equals(ProfileState.IN_GAME) && profile.getMatch() != null;
    }

    private Optional<Profile> getProfile(Player player) {
        Profile profile = API.getProfile(player);
        return this.isPlayerInMatch(profile) ? Optional.of(profile) : Optional.empty();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCrystalSpawn(EntitySpawnEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EnderCrystal) {
            EnderCrystal crystal = (EnderCrystal)entity;
            Player player = this.getNearbyPlayer(crystal.getLocation());
            if (player == null) {
                return;
            }
            this.getMatchForPlayer(player).ifPresent(match -> match.getEntities().add((Entity)crystal));
        }
    }

    @EventHandler
    public void onBlockPlaceEvent(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Profile profile = API.getProfile(player);
        if (profile == null) {
            return;
        }
        if (profile.getState() == ProfileState.IN_CUSTOM) {
            return;
        }
        if (!this.isPlayerInMatch(profile)) {
            event.setCancelled(true);
            return;
        }
        Match match = profile.getMatch();
        Location blockLocation = event.getBlock().getLocation();
        if (match != null && match.getKit().is(KitRule.BUILD)) {
            if (match.getState().equals(MatchState.STARTING)) {
                event.setCancelled(true);
                player.sendMessage((Component)CC.color("&cYou can't place blocks yet!"));
                return;
            }
            Arena arena = match.getArena();
            if (blockLocation.getY() >= arena.getBuildLimit()) {
                event.setCancelled(true);
                player.sendMessage((Component)CC.color("&cYou have reached build limit!"));
                return;
            }
            if (!LocationUtil.isInside(blockLocation, arena.getMin(), arena.getMax())) {
                event.setCancelled(true);
                player.sendMessage((Component)CC.color("&cYou can't build outside the arena!"));
                return;
            }
            if (blockLocation.equals((Object)match.getArena().getRedSpawn()) || blockLocation.equals((Object)match.getArena().getRedSpawn().clone().add(0.0, 1.0, 0.0))) {
                event.setCancelled(true);
                return;
            }
            if (blockLocation.equals((Object)match.getArena().getBlueSpawn()) || blockLocation.equals((Object)match.getArena().getBlueSpawn().clone().add(0.0, 1.0, 0.0))) {
                event.setCancelled(true);
                return;
            }
            if (event.getBlock().getType() == Material.TNT && match.getKit().getRules().get(KitRule.AUTO_IGNITE).booleanValue()) {
                event.setCancelled(true);
                ItemStack handItem = player.getInventory().getItemInMainHand();
                if (handItem.getType() == Material.TNT) {
                    handItem.setAmount(handItem.getAmount() - 1);
                }
                TNTPrimed tnt = (TNTPrimed)event.getPlayer().getWorld().spawnEntity(event.getBlockPlaced().getLocation().add(0.5, 0.5, 0.5), EntityType.TNT);
                tnt.setFuseTicks(20);
                tnt.getPersistentDataContainer().set(this.explosiveOwnerKey, PersistentDataType.STRING, (Object)event.getPlayer().getUniqueId().toString());
                match.getEntities().add((Entity)tnt);
            }
            match.getPlacedBlocks().add(blockLocation);
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCreeperSpawn(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getItem() == null || event.getItem().getType() != Material.CREEPER_SPAWN_EGG) {
            return;
        }
        Optional<Profile> profileOpt = this.getProfile(event.getPlayer());
        if (profileOpt.isEmpty()) {
            return;
        }
        if (!profileOpt.get().getMatch().getKit().getRules().get(KitRule.AUTO_IGNITE).booleanValue()) {
            return;
        }
        Location spawnLocation = event.getInteractionPoint();
        Creeper creeper = (Creeper)spawnLocation.getWorld().spawnEntity(spawnLocation, EntityType.CREEPER, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        creeper.ignite();
        creeper.getPersistentDataContainer().set(this.explosiveOwnerKey, PersistentDataType.STRING, (Object)event.getPlayer().getUniqueId().toString());
        profileOpt.get().getMatch().getEntities().add((Entity)creeper);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player player;
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        if (API.getProfile(event.getDamager().getUniqueId()).getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EnderCrystal) {
            EnderCrystal crystal = (EnderCrystal)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                player = (Player)entity;
                if (!this.getProfile(player).isPresent()) {
                    event.setCancelled(true);
                    return;
                }
                crystal.getPersistentDataContainer().set(this.explosiveOwnerKey, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            }
        }
        if ((entity = event.getEntity()) instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                player = (Player)entity;
                if (!this.getProfile(player).isPresent()) {
                    event.setCancelled(true);
                    return;
                }
                creeper.getPersistentDataContainer().set(this.explosiveOwnerKey, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            }
        }
        if ((entity = event.getEntity()) instanceof TNTPrimed) {
            TNTPrimed tnt = (TNTPrimed)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                player = (Player)entity;
                if (!this.getProfile(player).isPresent()) {
                    event.setCancelled(true);
                    return;
                }
                tnt.getPersistentDataContainer().set(this.explosiveOwnerKey, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosion(EntityExplodeEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (!(entity instanceof EnderCrystal || entity instanceof Creeper || entity instanceof TNTPrimed)) {
            return;
        }
        String uuid = (String)entity.getPersistentDataContainer().get(this.explosiveOwnerKey, PersistentDataType.STRING);
        if (uuid == null || uuid.isEmpty()) {
            return;
        }
        try {
            player = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
        }
        catch (IllegalArgumentException e) {
            event.setCancelled(true);
            return;
        }
        this.getMatchForPlayer(player).ifPresent(match -> {
            Arena arena = match.getArena();
            ArrayList originalBlocks = new ArrayList(event.blockList());
            List<Block> allowedBlocks = originalBlocks.stream().filter(block -> arena.getWhitelistedBlocks().contains(block.getType())).toList();
            event.blockList().clear();
            event.blockList().addAll(allowedBlocks);
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onFriendlyFire(EntityDamageByEntityEvent event) {
        TeamFightMatch teamMatch;
        if (SettingsLocale.FRIENDLY_FIRE.getBoolean()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Player owner = this.getResponsiblePlayer(event);
        if (owner == null) {
            return;
        }
        Optional<Match> ownerMatchOptional = this.getMatchForPlayer(owner);
        Optional<Match> victimMatchOptional = this.getMatchForPlayer(victim);
        if (ownerMatchOptional.isEmpty() || victimMatchOptional.isEmpty()) {
            return;
        }
        Match match = ownerMatchOptional.get();
        if (!match.getUuid().equals(victimMatchOptional.get().getUuid())) {
            return;
        }
        if (!(match instanceof TeamFightMatch) || !(teamMatch = (TeamFightMatch)match).onSameTeam(owner.getUniqueId(), victim.getUniqueId())) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onEnderPearlUse(PlayerInteractEvent event) {
        final Player player = event.getPlayer();
        if (!event.getAction().isRightClick()) {
            return;
        }
        if (event.getHand() == null) {
            return;
        }
        if (player.getInventory().getItem(event.getHand()).getType() != Material.ENDER_PEARL) {
            return;
        }
        Optional<Profile> profileOpt = this.getProfile(player);
        if (ProfileService.get().getByUUID(player.getUniqueId()).getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        if (!profileOpt.isPresent()) {
            event.setCancelled(true);
            return;
        }
        Profile profile = profileOpt.get();
        Match match = profile.getMatch();
        if (match.getState().equals(MatchState.STARTING)) {
            event.setCancelled(true);
        }
        if (!match.getKit().is(KitRule.ENDERPEARL_COOLDOWN)) {
            return;
        }
        Participant participant = match.getParticipant(player);
        if (player.hasCooldown(Material.ENDER_PEARL)) {
            int ticksLeft = player.getCooldown(Material.ENDER_PEARL);
            if (ticksLeft > 0) {
                double secondsLeft = (double)ticksLeft / 20.0;
                participant.sendMessage(MessagesLocale.MATCH_ENDERPEARL_COOLDOWN_ON_GOING, new Replacement("<time>", String.valueOf(secondsLeft)));
            }
        } else {
            new NeptuneRunnable(this){

                public void run() {
                    player.setCooldown(Material.ENDER_PEARL, 300);
                }
            }.startLater(1L);
        }
    }

    private boolean isSpectator(Player player) {
        Profile profile = API.getProfile(player);
        return profile != null && profile.getState() == ProfileState.IN_SPECTATOR;
    }

    @EventHandler
    public void onVehicleEnter(VehicleEnterEvent event) {
        Player player;
        Entity entity = event.getEntered();
        if (entity instanceof Player && this.isSpectator(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onVehicleExit(VehicleExitEvent event) {
        Player player;
        LivingEntity livingEntity = event.getExited();
        if (livingEntity instanceof Player && this.isSpectator(player = (Player)livingEntity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityPush(EntityPushedByEntityAttackEvent event) {
        Player attacker;
        ItemStack item;
        Entity entity;
        Entity entity2 = event.getPushedBy();
        if (!(entity2 instanceof WindCharge)) {
            return;
        }
        WindCharge wc = (WindCharge)entity2;
        Entity pushed = event.getEntity();
        ProjectileSource projectileSource = wc.getShooter();
        if (!(projectileSource instanceof Player)) {
            event.setCancelled(true);
            return;
        }
        Player shooter = (Player)projectileSource;
        if (!(pushed instanceof Player)) {
            return;
        }
        Player target = (Player)pushed;
        if (!this.getProfile(shooter).isPresent() || !this.getProfile(target).isPresent()) {
            event.setCancelled(true);
            return;
        }
        if (!target.canSee(shooter) || !shooter.canSee(target)) {
            event.setCancelled(true);
        }
        if ((entity = event.getPushedBy()) instanceof Player && (item = (attacker = (Player)entity).getInventory().getItemInMainHand()).getType() == Material.MACE) {
            Entity entity3 = event.getEntity();
            if (!(entity3 instanceof Player)) {
                return;
            }
            Player victim = (Player)entity3;
            if (!this.getProfile(attacker).isPresent() || !this.getProfile(victim).isPresent()) {
                event.setCancelled(true);
                return;
            }
            if (!victim.canSee(attacker) || !attacker.canSee(victim)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        Player player = event.getEntity();
        event.deathMessage(null);
        event.getDrops().clear();
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            return;
        }
        Profile profile = profileOpt.get();
        Match match = profile.getMatch();
        Participant participant = match.getParticipant(player.getUniqueId());
        if (participant == null) {
            return;
        }
        participant.setDeathCause(participant.getLastAttacker() != null ? DeathCause.KILL : DeathCause.DIED);
        MatchParticipantDeathEvent deathEvent = new MatchParticipantDeathEvent(match, participant, participant.getDeathCause().getMessage().getString());
        Bukkit.getPluginManager().callEvent((Event)deathEvent);
        match.onDeath(participant);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            if (event.getEntity() instanceof Player) {
                Profile profile = API.getProfile(attacker);
                if (profile == null) {
                    return;
                }
                if (profile.getState().equals(ProfileState.IN_CUSTOM)) {
                    return;
                }
                if (!this.isPlayerInMatch(profile)) {
                    event.setCancelled(true);
                    return;
                }
                Match match = profile.getMatch();
                if (match != null && match.getKit().is(KitRule.PARKOUR)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onPressurePlate(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getAction() == Action.PHYSICAL) {
            Material blockType;
            Material material = blockType = event.getClickedBlock() != null ? event.getClickedBlock().getType() : null;
            if (blockType == null) {
                return;
            }
            Optional<Profile> profileOpt = this.getProfile(player);
            if (!profileOpt.isPresent()) {
                return;
            }
            Profile profile = profileOpt.get();
            Match match = profile.getMatch();
            if (!match.getKit().is(KitRule.PARKOUR)) {
                return;
            }
            if (!match.getState().equals(MatchState.IN_ROUND)) {
                return;
            }
            Participant participant = match.getParticipant(player);
            if (participant == null) {
                return;
            }
            if (blockType.equals((Object)Material.HEAVY_WEIGHTED_PRESSURE_PLATE)) {
                if (participant.setCurrentCheckPoint(event.getClickedBlock().getLocation().clone().add(0.0, 1.0, 0.0))) {
                    match.broadcast(MessagesLocale.PARKOUR_CHECKPOINT, new Replacement("<player>", participant.getNameColored()), new Replacement("<checkpoint>", String.valueOf(participant.getCheckPoint())), new Replacement("<time>", participant.getTime().formatSecondsMillis()));
                }
            } else if (blockType.equals((Object)Material.LIGHT_WEIGHTED_PRESSURE_PLATE)) {
                match.win(participant);
                match.broadcast(MessagesLocale.PARKOUR_END, new Replacement("<player>", participant.getNameColored()), new Replacement("<time>", participant.getTime().formatSecondsMillis()));
            }
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                return;
            }
            Profile profile = API.getProfile(player);
            if (profile == null) {
                return;
            }
            if (!this.isPlayerInMatch(profile)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Profile profile = API.getProfile(player);
        if (profile != null && profile.getState() != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            event.setCancelled(true);
            return;
        }
        Match match = profile.getMatch();
        Location blockLocation = event.getBlock().getLocation();
        if (match != null && match.getKit().is(KitRule.BUILD)) {
            if (match.getState().equals(MatchState.STARTING)) {
                event.setCancelled(true);
                player.sendMessage((Component)CC.color("&cYou can't place blocks yet!"));
                return;
            }
            Arena arena = match.getArena();
            if (blockLocation.getY() >= arena.getBuildLimit()) {
                event.setCancelled(true);
                player.sendMessage((Component)CC.color("&cYou have reached build limit!"));
                return;
            }
            if (!LocationUtil.isInside(blockLocation, arena.getMin(), arena.getMax())) {
                event.setCancelled(true);
                player.sendMessage((Component)CC.color("&cYou can't place water outside the arena!"));
                return;
            }
            match.getPlacedBlocks().add(blockLocation);
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntityMonitor(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof Player) {
                TeamFightMatch teamFightMatch;
                Player player = (Player)entity;
                Profile attackerProfile = API.getProfile(attacker.getUniqueId());
                Profile profile = API.getProfile(player);
                if (profile == null) {
                    return;
                }
                if (profile.getState().equals(ProfileState.IN_CUSTOM)) {
                    return;
                }
                if (!this.isPlayerInMatch(profile) || !this.isPlayerInMatch(attackerProfile)) {
                    event.setCancelled(true);
                    return;
                }
                Match match = profile.getMatch();
                if (!attackerProfile.getMatch().getUuid().equals(match.getUuid())) {
                    event.setCancelled(true);
                    return;
                }
                if (match.getParticipant(attacker).isDead()) {
                    event.setCancelled(true);
                }
                if (match instanceof TeamFightMatch && (teamFightMatch = (TeamFightMatch)match).onSameTeam(player.getUniqueId(), attacker.getUniqueId())) {
                    event.setCancelled(true);
                }
                if (!match.getState().equals(MatchState.IN_ROUND)) {
                    event.setCancelled(true);
                }
                match.getParticipant(player.getUniqueId()).setLastAttacker(match.getParticipant(attacker.getUniqueId()));
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerHitEvent(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                Player damager = (Player)entity;
                Profile targetProfile = API.getProfile(target);
                Profile playerProfile = API.getProfile(damager.getUniqueId());
                if (playerProfile.getState().equals(ProfileState.IN_CUSTOM)) {
                    return;
                }
                if (!this.isPlayerInMatch(targetProfile) || !this.isPlayerInMatch(playerProfile)) {
                    event.setCancelled(true);
                    return;
                }
                if ((double)damager.getAttackCooldown() >= 0.2) {
                    Match match = targetProfile.getMatch();
                    Participant opponent = match.getParticipant(target.getUniqueId());
                    if ((double)damager.getAttackCooldown() > 0.7) {
                        match.getParticipant(damager.getUniqueId()).handleHit(opponent);
                    }
                    opponent.resetCombo();
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            return;
        }
        if (!(event.getFinalDamage() >= player.getHealth())) {
            return;
        }
        if (player.getInventory().getItemInMainHand().getType().equals((Object)Material.TOTEM_OF_UNDYING) || player.getInventory().getItemInOffHand().getType().equals((Object)Material.TOTEM_OF_UNDYING)) {
            return;
        }
        Profile profile = profileOpt.get();
        Match match = profile.getMatch();
        Participant participant = match.getParticipant(player.getUniqueId());
        participant.setDeathCause(DeathCause.DIED);
        match.onDeath(participant);
        player.setHealth(20.0);
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerMoveEvent(PlayerMoveEvent event) {
        if (!event.hasChangedPosition()) {
            return;
        }
        Player player = event.getPlayer();
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            return;
        }
        Profile profile = profileOpt.get();
        Match match = profile.getMatch();
        Arena arena = match.getArena();
        Participant participant = match.getParticipant(player.getUniqueId());
        if (participant == null) {
            return;
        }
        if (participant.isFrozen()) {
            Location to = event.getTo();
            Location from = event.getFrom();
            if (to.getX() != from.getX() || to.getZ() != from.getZ()) {
                player.teleport(from);
                return;
            }
        }
        if (player.getLocation().getY() <= (double)arena.getDeathY() && !participant.isDead()) {
            if (match.getKit().is(KitRule.PARKOUR)) {
                player.teleport(participant.getSpawn(match));
            } else {
                participant.setDeathCause(DeathCause.DIED);
                match.onDeath(participant);
            }
            return;
        }
        if (match.getState().equals(MatchState.IN_ROUND)) {
            Block block;
            Location playerLocation = player.getLocation();
            if (match.getKit().is(KitRule.DROPPER)) {
                block = playerLocation.getBlock();
                if (block.getType() == Material.WATER) {
                    match.win(participant);
                }
                return;
            }
            if (match.getKit().is(KitRule.SUMO) && (block = playerLocation.getBlock()).getType() == Material.WATER) {
                participant.setDeathCause(participant.getLastAttacker() != null ? DeathCause.KILL : DeathCause.DIED);
                match.onDeath(participant);
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player;
        Optional<Profile> profileOpt;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Material blockType = clickedBlock.getType();
        if (this.isStrippable(blockType) && (profileOpt = this.getProfile(player = event.getPlayer())).isPresent()) {
            event.setCancelled(true);
        }
    }

    private boolean isStrippable(Material material) {
        return material == Material.OAK_LOG || material == Material.SPRUCE_LOG || material == Material.BIRCH_LOG || material == Material.JUNGLE_LOG || material == Material.ACACIA_LOG || material == Material.DARK_OAK_LOG || material == Material.MANGROVE_LOG || material == Material.CHERRY_LOG || material == Material.CRIMSON_STEM || material == Material.COPPER_BLOCK || material == Material.WARPED_STEM;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ProfileService profileService = ProfileService.get();
            Profile profileDirect = profileService.getByUUID(player.getUniqueId());
            if (profileDirect == null) {
                event.setCancelled(true);
                return;
            }
            if (profileDirect.getState() == ProfileState.IN_CUSTOM) {
                return;
            }
            Optional<Profile> profileOpt = this.getProfile(player);
            if (!profileOpt.isPresent()) {
                event.setCancelled(true);
                return;
            }
            Profile profile = profileOpt.get();
            Match match = profile.getMatch();
            Kit kit = match.getKit();
            if (match.getState() == MatchState.STARTING || match.getState() == MatchState.ENDING) {
                event.setCancelled(true);
                return;
            }
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL && !kit.is(KitRule.FALL_DAMAGE)) {
                event.setCancelled(true);
                return;
            }
            if (!kit.is(KitRule.DAMAGE)) {
                event.setDamage(0.0);
                return;
            }
            if (match.getParticipant(player).isDead()) {
                event.setCancelled(true);
                return;
            }
            if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
                event.setDamage(event.getDamage() * kit.getDamageMultiplier());
            }
        }
    }

    @EventHandler
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        HumanEntity humanEntity = event.getEntity();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            if (API.getProfile(player) == null) {
                return;
            }
            if (API.getProfile(player).getState().equals(ProfileState.IN_CUSTOM)) {
                return;
            }
            Optional<Profile> profileOpt = this.getProfile(player);
            if (!profileOpt.isPresent()) {
                event.setCancelled(true);
                return;
            }
            Profile profile = profileOpt.get();
            Match match = profile.getMatch();
            if (!match.getKit().is(KitRule.HUNGER)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPlayerRegainHealth(EntityRegainHealthEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional<Profile> profileOpt = this.getProfile(player);
            if (!profileOpt.isPresent()) {
                return;
            }
            Profile profile = profileOpt.get();
            Match match = profile.getMatch();
            if (event.getRegainReason() == EntityRegainHealthEvent.RegainReason.SATIATED && !match.getKit().is(KitRule.SATURATION_HEAL)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onBlockBreakEvent(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Profile playerProfile = API.getProfile(player);
        if (playerProfile != null && playerProfile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            event.setCancelled(true);
            return;
        }
        Profile profile = profileOpt.get();
        Match match = profile.getMatch();
        Arena arena = match.getArena();
        if (profile.getState().equals(ProfileState.IN_SPECTATOR)) {
            event.setCancelled(true);
            return;
        }
        Material blockType = event.getBlock().getType();
        Location blockLocation = event.getBlock().getLocation();
        if (blockType == Material.FIRE) {
            return;
        }
        if (blockType.name().contains("BED")) {
            return;
        }
        boolean cancel = true;
        if (match.getKit().is(KitRule.BUILD) && match.getPlacedBlocks().contains(blockLocation)) {
            cancel = false;
        } else if (match.getKit().is(KitRule.ALLOW_ARENA_BREAK) && arena.getWhitelistedBlocks().contains(blockType)) {
            cancel = false;
        }
        event.setCancelled(cancel);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockDrop(BlockDropItemEvent event) {
        this.getMatchForPlayer(event.getPlayer()).ifPresentOrElse(match -> match.getEntities().addAll(event.getItems()), () -> event.setCancelled(true));
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakBlockEvent event) {
        event.getDrops().clear();
    }

    @EventHandler
    public void onBedBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Profile playerProfile = API.getProfile(player);
        if (playerProfile != null && playerProfile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            event.setCancelled(true);
            return;
        }
        Profile profile = profileOpt.get();
        Match match = profile.getMatch();
        Material blockType = event.getBlock().getType();
        if (!match.getKit().is(KitRule.BED_WARS)) {
            return;
        }
        if (match.getKit().is(KitRule.BED_WARS) && (blockType == Material.OAK_PLANKS || blockType == Material.END_STONE)) {
            event.setCancelled(false);
        }
        if (match.getKit().is(KitRule.BED_WARS) && event.getBlock().getType().toString().contains("BED")) {
            Location bed = event.getBlock().getLocation();
            Participant participant = match.getParticipant(player.getUniqueId());
            if (participant == null) {
                return;
            }
            Location spawn = match.getSpawn(participant);
            Participant opponent = participant.getOpponent();
            Location opponentSpawn = match.getSpawn(opponent);
            if (bed.distanceSquared(spawn) > bed.distanceSquared(opponentSpawn)) {
                event.setDropItems(false);
                match.breakBed(opponent, participant);
                match.sendTitle(opponent, CC.color(MessagesLocale.BED_BREAK_TITLE.getString()), CC.color(MessagesLocale.BED_BREAK_FOOTER.getString()), 20);
                match.broadcast(opponent.getColor().equals(ParticipantColor.RED) ? MessagesLocale.RED_BED_BROKEN_MESSAGE : MessagesLocale.BLUE_BED_BROKEN_MESSAGE, new Replacement("<player>", participant.getNameColored()));
            } else {
                event.setCancelled(true);
                participant.sendMessage(MessagesLocale.CANT_BREAK_OWN_BED, new Replacement[0]);
            }
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        ProjectileSource shooter = projectile.getShooter();
        if (shooter instanceof Player) {
            Player player = (Player)shooter;
            if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                return;
            }
            Profile profile = API.getProfile(player);
            if (profile == null) {
                event.setCancelled(true);
                return;
            }
            if (profile.getState().equals(ProfileState.IN_CUSTOM)) {
                return;
            }
            Match match = profile.getMatch();
            if (profile.getMatch() == null) {
                event.setCancelled(true);
                return;
            }
            match.getEntities().add((Entity)projectile);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onExplode(BlockExplodeEvent event) {
        Player player = this.getNearbyPlayer(event.getBlock().getLocation());
        if (player == null) {
            event.setCancelled(true);
            return;
        }
        this.getMatchForPlayer(player).ifPresent(match -> {
            Arena arena = match.getArena();
            ArrayList originalBlocks = new ArrayList(event.blockList());
            List<Block> allowedBlocks = originalBlocks.stream().filter(block -> arena.getWhitelistedBlocks().contains(block.getType())).toList();
            event.blockList().clear();
            event.blockList().addAll(allowedBlocks);
        });
    }

    @EventHandler
    public void onItemDrop(BlockBreakBlockEvent event) {
        Player player = this.getNearbyPlayer(event.getBlock().getLocation());
        if (player == null) {
            event.getDrops().clear();
            return;
        }
        this.getMatchForPlayer(player).ifPresent(match -> Bukkit.getScheduler().runTaskLater((Plugin)Neptune.get(), () -> {
            for (ItemStack item : event.getDrops()) {
                match.getEntities().add(EntityUtils.getEntityByItemStack(player.getWorld(), item));
            }
        }, 1L));
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Optional<Profile> profileOpt = this.getProfile(player);
        if (!profileOpt.isPresent()) {
            event.setCancelled(true);
        } else {
            Profile profile = profileOpt.get();
            profile.getMatch().getEntities().add((Entity)event.getItemDrop());
        }
    }

    private Player getResponsiblePlayer(EntityDamageByEntityEvent event) {
        EnderCrystal crystal;
        String uuid;
        AreaEffectCloud cloud;
        ThrownPotion potion;
        Projectile proj;
        TNTPrimed tnt;
        Entity entity;
        Entity damager = event.getDamager();
        if (damager instanceof Player) {
            Player p = (Player)damager;
            return p;
        }
        if (damager instanceof TNTPrimed && (entity = (tnt = (TNTPrimed)damager).getSource()) instanceof Player) {
            Player source = (Player)entity;
            return source;
        }
        if (damager instanceof Projectile && (entity = (proj = (Projectile)damager).getShooter()) instanceof Player) {
            Player shooter = (Player)entity;
            return shooter;
        }
        if (damager instanceof ThrownPotion && (entity = (potion = (ThrownPotion)damager).getShooter()) instanceof Player) {
            Player thrower = (Player)entity;
            return thrower;
        }
        if (damager instanceof AreaEffectCloud && (entity = (cloud = (AreaEffectCloud)damager).getSource()) instanceof Player) {
            Player source = (Player)entity;
            return source;
        }
        if (damager instanceof EnderCrystal && (uuid = (String)(crystal = (EnderCrystal)damager).getPersistentDataContainer().get(this.explosiveOwnerKey, PersistentDataType.STRING)) != null) {
            return Bukkit.getPlayer((UUID)UUID.fromString(uuid));
        }
        return null;
    }

    private Player getNearbyPlayer(Location location) {
        return WorldUtils.getPlayersInRadius(location, 10.0).stream().findFirst().orElse(null);
    }

    private Optional<Match> getMatchForPlayer(Player player) {
        Profile profile = API.getProfile(player);
        return Optional.ofNullable(profile).filter(this::isPlayerInMatch).map(Profile::getMatch);
    }
}

