/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.tasks;

import dev.lrxh.api.events.MatchEndEvent;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.feature.hotbar.HotbarService;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.MatchService;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.PlayerUtil;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class MatchEndRunnable
extends NeptuneRunnable {
    private final Match match;
    private int endTimer = 3;

    public MatchEndRunnable(Match match) {
        this.match = match;
        match.getTime().setStop(true);
    }

    public void run() {
        if (!MatchService.get().matches.contains(this.match)) {
            this.stop();
            return;
        }
        if (this.endTimer == 0) {
            this.match.setState(MatchState.ENDING);
            if (this.match.getKit().is(KitRule.SHOW_HP)) {
                this.match.hideHealth();
            }
            for (UUID spectator : new HashSet<UUID>(this.match.spectators)) {
                this.match.removeSpectator(spectator, false);
            }
            this.match.resetArena();
            if (!SettingsLocale.ARENA_DUPLICATES.getBoolean()) {
                this.match.getArena().setUsed(false);
            }
            this.match.forEachParticipant(participant -> {
                Profile profile = API.getProfile(participant.getPlayerUUID());
                if (profile.getMatch() != this.match) {
                    return;
                }
                PlayerUtil.reset(participant.getPlayer());
                profile.setMatch(null);
                PlayerUtil.teleportToSpawn(participant.getPlayerUUID());
                profile.setState(profile.getGameData().getParty() == null ? ProfileState.IN_LOBBY : ProfileState.IN_PARTY);
                this.match.forEachPlayer(player -> HotbarService.get().giveItems((Player)player));
            });
            this.match.sendEndMessage();
            this.match.getArena().remove();
            MatchService.get().matches.remove(this.match);
            MatchEndEvent event = new MatchEndEvent(this.match);
            Bukkit.getPluginManager().callEvent((Event)event);
            this.stop();
        }
        --this.endTimer;
    }
}

