/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.tasks;

import dev.lrxh.api.events.MatchParticipantRespawnEvent;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.MatchService;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.participant.ParticipantColor;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.PlayerUtil;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.event.Event;

public class MatchRespawnRunnable
extends NeptuneRunnable {
    private final Match match;
    private final Participant participant;
    private int respawnTimer = 3;

    public MatchRespawnRunnable(Match match, Participant participant) {
        this.match = match;
        this.participant = participant;
        match.hideParticipant(participant);
    }

    public void run() {
        if (!MatchService.get().matches.contains(this.match) || this.participant.isLeft()) {
            this.stop();
            return;
        }
        if (this.respawnTimer == 3) {
            PlayerUtil.doVelocityChange(this.participant.getPlayerUUID());
            PlayerUtil.reset(this.participant.getPlayer());
            this.participant.getPlayer().setGameMode(GameMode.SPECTATOR);
        }
        if (this.participant.getPlayer() == null) {
            return;
        }
        if (this.respawnTimer == 0) {
            Location location = this.participant.getColor().equals(ParticipantColor.RED) ? this.match.getArena().getRedSpawn() : this.match.getArena().getBlueSpawn();
            this.participant.teleport(location);
            this.match.setupPlayer(this.participant.getPlayerUUID());
            this.participant.setDead(false);
            this.match.showParticipant(this.participant);
            this.participant.sendMessage(MessagesLocale.MATCH_RESPAWNED, new Replacement[0]);
            this.stop();
            MatchParticipantRespawnEvent event = new MatchParticipantRespawnEvent(this.match, this.participant);
            Bukkit.getPluginManager().callEvent((Event)event);
            return;
        }
        this.participant.playSound(Sound.UI_BUTTON_CLICK);
        this.participant.sendTitle(CC.color(MessagesLocale.MATCH_RESPAWN_TITLE_HEADER.getString().replace("<timer>", String.valueOf(this.respawnTimer))), CC.color(MessagesLocale.MATCH_RESPAWN_TITLE_FOOTER.getString().replace("<timer>", String.valueOf(this.respawnTimer))), 19);
        this.participant.sendMessage(MessagesLocale.MATCH_RESPAWN_TIMER, new Replacement("<timer>", String.valueOf(this.respawnTimer)));
        --this.respawnTimer;
    }
}

