/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.tasks;

import dev.lrxh.api.events.MatchNewRoundStartEvent;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.MatchService;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.event.Event;

public class MatchSecondRoundRunnable
extends NeptuneRunnable {
    private final Match match;
    private final Participant participant;
    private int respawnTimer = 3;

    public MatchSecondRoundRunnable(Match match, Participant participant) {
        this.match = match;
        this.participant = participant;
        match.setupParticipants();
        match.checkRules();
        match.teleportToPositions();
    }

    public void run() {
        if (!MatchService.get().matches.contains(this.match) || this.participant.isLeft()) {
            this.stop();
            return;
        }
        if (this.match.isEnded()) {
            this.stop();
            return;
        }
        if (this.participant.getPlayer() == null) {
            return;
        }
        if (this.respawnTimer == 0) {
            this.match.startMatch();
            this.match.checkRules();
            this.match.sendMessage(MessagesLocale.ROUND_STARTED, new Replacement[0]);
            this.stop();
            return;
        }
        if (this.match.getState().equals(MatchState.STARTING)) {
            this.match.playSound(Sound.UI_BUTTON_CLICK);
            this.match.sendTitle(CC.color(MessagesLocale.MATCH_STARTING_TITLE_HEADER.getString().replace("<countdown-time>", String.valueOf(this.respawnTimer))), CC.color(MessagesLocale.MATCH_STARTING_TITLE_FOOTER.getString().replace("<countdown-time>", String.valueOf(this.respawnTimer))), 19);
            this.match.sendMessage(MessagesLocale.ROUND_STARTING, new Replacement("<timer>", String.valueOf(this.respawnTimer)));
        }
        if (this.respawnTimer == 3) {
            this.match.setupParticipants();
            this.match.teleportToPositions();
            if (this.match.getKit().is(KitRule.RESET_ARENA_AFTER_ROUND)) {
                this.match.resetArena();
            }
            MatchNewRoundStartEvent event = new MatchNewRoundStartEvent(this.match);
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        --this.respawnTimer;
    }
}

