/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.game.match.tasks;

import dev.lrxh.api.events.MatchStartEvent;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.MatchState;
import dev.lrxh.neptune.game.match.impl.ffa.FfaFightMatch;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.data.SettingData;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.Time;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class MatchStartRunnable
extends NeptuneRunnable {
    private final Match match;
    private int startTimer;

    public MatchStartRunnable(Match match) {
        this.match = match;
        this.startTimer = match instanceof FfaFightMatch ? 5 : 3;
        match.teleportToPositions();
        match.setupParticipants();
        match.checkRules();
        match.getTime().setStop(true);
        match.getTime().setZero();
    }

    public void run() {
        if (this.match.isEnded()) {
            this.stop();
            return;
        }
        if (this.startTimer == 0) {
            this.match.sendMessage(MessagesLocale.MATCH_STARTED, new Replacement[0]);
            this.match.startMatch();
            this.match.checkRules();
            this.checkFollowings();
            this.match.getTime().setStop(false);
            for (Participant participant : this.match.getParticipantsList()) {
                participant.setTime(new Time());
            }
            this.stop();
            MatchStartEvent event = new MatchStartEvent(this.match);
            Bukkit.getPluginManager().callEvent((Event)event);
            return;
        }
        if (this.match.getState().equals(MatchState.STARTING)) {
            this.match.playSound(Sound.UI_BUTTON_CLICK);
            this.match.sendTitle(CC.color(MessagesLocale.MATCH_STARTING_TITLE_HEADER.getString().replace("<countdown-time>", String.valueOf(this.startTimer))), CC.color(MessagesLocale.MATCH_STARTING_TITLE_FOOTER.getString().replace("<countdown-time>", String.valueOf(this.startTimer))), 19);
            this.match.sendMessage(MessagesLocale.MATCH_STARTING, new Replacement("<timer>", String.valueOf(this.startTimer)));
        }
        --this.startTimer;
    }

    private void checkFollowings() {
        for (Participant participant : this.match.getParticipantsList()) {
            SettingData settingData;
            if (participant.isDisconnected() || (settingData = API.getProfile(participant.getPlayerUUID()).getSettingData()) == null || settingData.getFollowings().isEmpty()) continue;
            for (UUID uuid : settingData.getFollowings()) {
                Player particpiantPlayer;
                Player follower = Bukkit.getPlayer((UUID)uuid);
                if (follower == null || API.getProfile(follower).getState().equals(ProfileState.IN_GAME) || (particpiantPlayer = participant.getPlayer()) == null) continue;
                this.match.addSpectator(follower, particpiantPlayer, false, true);
            }
        }
    }
}

