/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile;

import dev.lrxh.api.profile.IProfile;
import dev.lrxh.api.profile.IProfileService;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.feature.queue.QueueService;
import dev.lrxh.neptune.profile.impl.Profile;
import java.util.IdentityHashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;

public class ProfileService
implements IProfileService {
    private static ProfileService instance;
    public final IdentityHashMap<UUID, Profile> profiles = new IdentityHashMap();
    private final Neptune plugin = Neptune.get();

    public static ProfileService get() {
        if (instance == null) {
            instance = new ProfileService();
        }
        return instance;
    }

    public CompletableFuture<Void> createProfile(Player player) {
        return Profile.create(player.getName(), player.getUniqueId(), this.plugin, false).thenAccept(profile -> this.profiles.put(player.getUniqueId(), (Profile)profile));
    }

    public CompletableFuture<Profile> createProfile(UUID uuid) {
        return Profile.create("username", uuid, this.plugin, true).thenApply(profile -> profile);
    }

    public void removeProfile(UUID playerUUID) {
        QueueService.get().remove(playerUUID);
        Profile profile = this.profiles.get(playerUUID);
        profile.disband();
        Profile.save(profile);
        this.profiles.remove(playerUUID);
    }

    public void saveAll() {
        for (Profile profile : this.profiles.values()) {
            Profile.save(profile);
        }
    }

    public Profile getByUUID(UUID playerUUID) {
        Profile profile = this.profiles.get(playerUUID);
        if (profile != null) {
            return profile;
        }
        for (UUID uuid : this.profiles.keySet()) {
            if (!uuid.toString().equals(playerUUID.toString())) continue;
            return this.profiles.get(uuid);
        }
        return null;
    }

    @Override
    public CompletableFuture<IProfile> getProfile(UUID uuid) {
        return this._getProfile(uuid).thenApply(p -> p);
    }

    public CompletableFuture<Profile> _getProfile(UUID uuid) {
        Profile profile = this.getByUUID(uuid);
        return profile != null ? CompletableFuture.completedFuture(profile) : this.createProfile(uuid).thenApply(p -> p);
    }
}

