/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.lrxh.api.data.IGameData;
import dev.lrxh.api.data.IKitData;
import dev.lrxh.api.kit.IKit;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.feature.party.Party;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.KitService;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.profile.data.GlobalStats;
import dev.lrxh.neptune.profile.data.KitData;
import dev.lrxh.neptune.profile.data.MatchHistory;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.request.Request;
import dev.lrxh.neptune.utils.TtlAction;
import dev.lrxh.neptune.utils.TtlHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.entity.Player;

public class GameData
implements IGameData {
    private final TtlHashMap<UUID, Request> requests = new TtlHashMap((long)SettingsLocale.REQUEST_EXPIRY_TIME.getInt());
    private Match match;
    private HashMap<Kit, KitData> kitData;
    private ArrayList<MatchHistory> matchHistories;
    private Gson gson;
    private Kit kitEditor;
    private Party party;
    private GlobalStats globalStats;
    private String lastPlayedKit;
    private HashMap<String, Object> customData = new HashMap();
    private HashMap<String, Object> persistentData = new HashMap();

    public GameData(Profile profile) {
        this.kitData = new HashMap();
        this.matchHistories = new ArrayList();
        this.gson = new GsonBuilder().setPrettyPrinting().create();
        for (Kit kit : KitService.get().kits) {
            this.kitData.put(kit, new KitData());
        }
        this.globalStats = new GlobalStats(profile);
        this.lastPlayedKit = "";
    }

    public KitData get(Kit kit) {
        if (!this.kitData.containsKey(kit)) {
            this.kitData.put(kit, new KitData());
        }
        return this.kitData.get(kit);
    }

    @Override
    public HashMap<IKit, IKitData> getKitData() {
        return new HashMap<IKit, IKitData>(this.kitData);
    }

    @Override
    public void setCustomData(String key, Object value) {
        this.customData.put(key, value);
    }

    @Override
    public Object getCustomData(String key) {
        return this.customData.get(key);
    }

    @Override
    public void setPersistentData(String key, Object value) {
        this.persistentData.put(key, value);
    }

    @Override
    public Object getPersistentData(String key) {
        return this.persistentData.get(key) != null ? this.persistentData.get(key) : null;
    }

    public HashMap<Kit, KitData> getKitDataInternal() {
        return this.kitData;
    }

    public boolean run(Kit kit, boolean won) {
        this.lastPlayedKit = kit.getName();
        KitData kitData = this.kitData.get(kit);
        boolean value = false;
        if (won) {
            value = this.updateWin(kitData);
        } else {
            this.updateLosses(kitData);
        }
        this.globalStats.update();
        return value;
    }

    private boolean updateWin(KitData kitData) {
        kitData.setKills(kitData.getKills() + 1);
        this.updateWinStreak(kitData, true);
        return kitData.updateElo(true);
    }

    private void updateLosses(KitData kitData) {
        kitData.setDeaths(kitData.getDeaths() + 1);
        kitData.updateElo(false);
        this.updateWinStreak(kitData, false);
    }

    private void updateWinStreak(KitData kitData, boolean won) {
        if (won) {
            kitData.setCurrentStreak(kitData.getCurrentStreak() + 1);
            if (kitData.getCurrentStreak() > kitData.getBestStreak()) {
                kitData.setBestStreak(kitData.getCurrentStreak());
            }
        } else {
            kitData.setCurrentStreak(kitData.getCurrentStreak() + 1);
            kitData.setCurrentStreak(0);
            this.globalStats.setCurrentStreak(0);
        }
    }

    public void addRequest(Request duelRequest, UUID name, Consumer<Player> action) {
        this.requests.put(name, duelRequest, new TtlAction(name, action));
    }

    public void removeRequest(UUID playerUUID) {
        this.requests.remove(playerUUID);
    }

    public List<String> serializeHistory() {
        if (this.matchHistories.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> serialized = new ArrayList<String>();
        for (MatchHistory matchHistory : this.matchHistories) {
            serialized.add(this.serialize(matchHistory));
        }
        return serialized;
    }

    public ArrayList<MatchHistory> deserializeHistory(List<String> historySerialized) {
        if (historySerialized == null || historySerialized.isEmpty()) {
            return new ArrayList<MatchHistory>();
        }
        ArrayList<MatchHistory> deserialized = new ArrayList<MatchHistory>();
        for (String serialized : historySerialized) {
            deserialized.add(this.deserialize(serialized));
        }
        return deserialized;
    }

    public void addHistory(MatchHistory matchHistory) {
        if (this.matchHistories.size() >= 7) {
            this.matchHistories.remove(0);
        }
        this.matchHistories.add(matchHistory);
    }

    private String serialize(MatchHistory matchHistory) {
        return this.gson.toJson((Object)matchHistory);
    }

    private MatchHistory deserialize(String serialized) {
        return (MatchHistory)this.gson.fromJson(serialized, MatchHistory.class);
    }

    @Generated
    public TtlHashMap<UUID, Request> getRequests() {
        return this.requests;
    }

    @Generated
    public Match getMatch() {
        return this.match;
    }

    @Generated
    public ArrayList<MatchHistory> getMatchHistories() {
        return this.matchHistories;
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public Kit getKitEditor() {
        return this.kitEditor;
    }

    @Generated
    public Party getParty() {
        return this.party;
    }

    @Override
    @Generated
    public GlobalStats getGlobalStats() {
        return this.globalStats;
    }

    @Generated
    public String getLastPlayedKit() {
        return this.lastPlayedKit;
    }

    @Generated
    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    @Generated
    public HashMap<String, Object> getPersistentData() {
        return this.persistentData;
    }

    @Generated
    public void setMatch(Match match) {
        this.match = match;
    }

    @Generated
    public void setKitData(HashMap<Kit, KitData> kitData) {
        this.kitData = kitData;
    }

    @Generated
    public void setMatchHistories(ArrayList<MatchHistory> matchHistories) {
        this.matchHistories = matchHistories;
    }

    @Generated
    public void setGson(Gson gson) {
        this.gson = gson;
    }

    @Generated
    public void setKitEditor(Kit kitEditor) {
        this.kitEditor = kitEditor;
    }

    @Generated
    public void setParty(Party party) {
        this.party = party;
    }

    @Generated
    public void setGlobalStats(GlobalStats globalStats) {
        this.globalStats = globalStats;
    }

    @Generated
    public void setLastPlayedKit(String lastPlayedKit) {
        this.lastPlayedKit = lastPlayedKit;
    }

    @Generated
    public void setCustomData(HashMap<String, Object> customData) {
        this.customData = customData;
    }

    @Generated
    public void setPersistentData(HashMap<String, Object> persistentData) {
        this.persistentData = persistentData;
    }
}

