/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile.data;

import dev.lrxh.api.data.IDivision;
import dev.lrxh.api.data.IGlobalStats;
import dev.lrxh.neptune.feature.divisions.DivisionService;
import dev.lrxh.neptune.feature.divisions.impl.Division;
import dev.lrxh.neptune.profile.data.KitData;
import dev.lrxh.neptune.profile.impl.Profile;
import lombok.Generated;

public class GlobalStats
implements IGlobalStats {
    private final Profile profile;
    private int wins = 0;
    private int losses = 0;
    private int currentStreak = 0;
    private int bestStreak = 0;
    private int elo = 0;
    private Division division = DivisionService.get().getDivisionByElo(0);

    public GlobalStats(Profile profile) {
        this.profile = profile;
    }

    @Override
    public void setDivision(IDivision division) {
        this.division = (Division)division;
    }

    public void update() {
        this.wins = 0;
        this.losses = 0;
        this.currentStreak = 0;
        this.bestStreak = 0;
        this.elo = 0;
        for (KitData kitData : this.profile.getGameData().getKitDataInternal().values()) {
            this.wins += kitData.getKills();
            this.losses += kitData.getDeaths();
            this.currentStreak += kitData.getCurrentStreak();
            this.bestStreak = Math.max(this.bestStreak, kitData.getBestStreak());
            this.elo += kitData.getElo();
        }
        int kitData = this.profile.getGameData().getKitDataInternal().size();
        if (kitData != 0) {
            this.elo /= kitData;
        }
        this.division = DivisionService.get().getDivisionByElo(this.elo);
    }

    @Override
    public double getWinRatio() {
        int totalGames = this.wins + this.losses;
        if (totalGames == 0) {
            return 0.0;
        }
        return Math.round((double)this.wins / (double)totalGames * 100.0);
    }

    @Generated
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    @Generated
    public int getWins() {
        return this.wins;
    }

    @Override
    @Generated
    public int getLosses() {
        return this.losses;
    }

    @Override
    @Generated
    public int getCurrentStreak() {
        return this.currentStreak;
    }

    @Override
    @Generated
    public int getBestStreak() {
        return this.bestStreak;
    }

    @Override
    @Generated
    public int getElo() {
        return this.elo;
    }

    @Override
    @Generated
    public Division getDivision() {
        return this.division;
    }

    @Override
    @Generated
    public void setWins(int wins) {
        this.wins = wins;
    }

    @Override
    @Generated
    public void setLosses(int losses) {
        this.losses = losses;
    }

    @Override
    @Generated
    public void setCurrentStreak(int currentStreak) {
        this.currentStreak = currentStreak;
    }

    @Override
    @Generated
    public void setBestStreak(int bestStreak) {
        this.bestStreak = bestStreak;
    }

    @Override
    @Generated
    public void setElo(int elo) {
        this.elo = elo;
    }
}

