/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile.data;

import dev.lrxh.api.data.IKitData;
import dev.lrxh.neptune.feature.divisions.DivisionService;
import dev.lrxh.neptune.feature.divisions.impl.Division;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;

public class KitData
implements IKitData {
    private int kills = 0;
    private int deaths = 0;
    private int bestStreak = 0;
    private int currentStreak = 0;
    private List<ItemStack> kitLoadout = new ArrayList<ItemStack>();
    private Division division;
    private int elo = 0;
    private HashMap<String, Object> customData = new HashMap();
    private HashMap<String, Object> persistentData = new HashMap();

    @Override
    public double getKdr() {
        if (this.deaths == 0) {
            return this.kills;
        }
        double kd = (double)this.kills / (double)this.deaths;
        BigDecimal bd = new BigDecimal(kd);
        bd = bd.setScale(1, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    @Override
    public void setCustomData(String key, Object value) {
        this.customData.put(key, value);
    }

    @Override
    public Object getCustomData(String key) {
        return this.customData.get(key);
    }

    @Override
    public void setPersistentData(String key, Object value) {
        this.persistentData.put(key, value);
    }

    @Override
    public Object getPersistentData(String key) {
        return this.persistentData.get(key) != null ? this.persistentData.get(key) : null;
    }

    public boolean updateElo(boolean won) {
        int max;
        int min;
        if (won) {
            if (this.elo < 300) {
                min = 15;
                max = 25;
            } else if (this.elo < 600) {
                min = 10;
                max = 20;
            } else if (this.elo < 900) {
                min = 5;
                max = 15;
            } else {
                min = 3;
                max = 10;
            }
        } else if (this.elo < 300) {
            min = -5;
            max = 0;
        } else if (this.elo < 600) {
            min = -10;
            max = -5;
        } else if (this.elo < 900) {
            min = -20;
            max = -10;
        } else {
            min = -25;
            max = -15;
        }
        int change = ThreadLocalRandom.current().nextInt(min, max + 1);
        this.elo += change;
        if (this.elo < 0) {
            this.elo = 0;
        }
        return this.updateDivision();
    }

    public boolean updateDivision() {
        Division previous = this.division;
        Division updated = DivisionService.get().getDivisionByElo(this.elo);
        if (updated == null) {
            updated = DivisionService.get().getDivisionByElo(0);
        }
        this.division = updated;
        if (previous == null) {
            return true;
        }
        int previousDivision = previous.getEloRequired();
        int newDivision = updated.getEloRequired();
        return newDivision > previousDivision;
    }

    @Override
    @Generated
    public int getKills() {
        return this.kills;
    }

    @Override
    @Generated
    public int getDeaths() {
        return this.deaths;
    }

    @Override
    @Generated
    public int getBestStreak() {
        return this.bestStreak;
    }

    @Override
    @Generated
    public int getCurrentStreak() {
        return this.currentStreak;
    }

    @Generated
    public List<ItemStack> getKitLoadout() {
        return this.kitLoadout;
    }

    @Generated
    public Division getDivision() {
        return this.division;
    }

    @Generated
    public int getElo() {
        return this.elo;
    }

    @Generated
    public HashMap<String, Object> getCustomData() {
        return this.customData;
    }

    @Generated
    public HashMap<String, Object> getPersistentData() {
        return this.persistentData;
    }

    @Override
    @Generated
    public void setKills(int kills) {
        this.kills = kills;
    }

    @Override
    @Generated
    public void setDeaths(int deaths) {
        this.deaths = deaths;
    }

    @Override
    @Generated
    public void setBestStreak(int bestStreak) {
        this.bestStreak = bestStreak;
    }

    @Override
    @Generated
    public void setCurrentStreak(int currentStreak) {
        this.currentStreak = currentStreak;
    }

    @Generated
    public void setKitLoadout(List<ItemStack> kitLoadout) {
        this.kitLoadout = kitLoadout;
    }

    @Generated
    public void setDivision(Division division) {
        this.division = division;
    }

    @Generated
    public void setElo(int elo) {
        this.elo = elo;
    }

    @Generated
    public void setCustomData(HashMap<String, Object> customData) {
        this.customData = customData;
    }

    @Generated
    public void setPersistentData(HashMap<String, Object> persistentData) {
        this.persistentData = persistentData;
    }
}

