/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile.data;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.feature.cosmetics.CosmeticService;
import dev.lrxh.neptune.feature.cosmetics.impl.KillEffect;
import dev.lrxh.neptune.feature.cosmetics.impl.KillMessagePackage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class SettingData {
    private final Neptune plugin;
    private boolean playerVisibility = true;
    private boolean allowSpectators = true;
    private boolean allowDuels = true;
    private boolean allowParty = true;
    private int maxPing = 350;
    private KillEffect killEffect = KillEffect.NONE;
    private boolean menuSound = true;
    private KillMessagePackage killMessagePackage;
    private List<UUID> followings = new ArrayList<UUID>();

    public SettingData(Neptune plugin) {
        this.plugin = plugin;
        this.killMessagePackage = CosmeticService.get().getDefault();
    }

    public void increasePing() {
        if (this.maxPing == 350) {
            return;
        }
        this.maxPing += 10;
    }

    public void decreasePing() {
        if (this.maxPing == 10) {
            return;
        }
        this.maxPing -= 10;
    }

    public void addFollower(UUID follower) {
        this.followings.add(follower);
    }

    public void removeFollower(UUID follower) {
        this.followings.remove(follower);
    }

    @Generated
    public Neptune getPlugin() {
        return this.plugin;
    }

    @Generated
    public boolean isPlayerVisibility() {
        return this.playerVisibility;
    }

    @Generated
    public boolean isAllowSpectators() {
        return this.allowSpectators;
    }

    @Generated
    public boolean isAllowDuels() {
        return this.allowDuels;
    }

    @Generated
    public boolean isAllowParty() {
        return this.allowParty;
    }

    @Generated
    public int getMaxPing() {
        return this.maxPing;
    }

    @Generated
    public KillEffect getKillEffect() {
        return this.killEffect;
    }

    @Generated
    public boolean isMenuSound() {
        return this.menuSound;
    }

    @Generated
    public KillMessagePackage getKillMessagePackage() {
        return this.killMessagePackage;
    }

    @Generated
    public List<UUID> getFollowings() {
        return this.followings;
    }

    @Generated
    public void setPlayerVisibility(boolean playerVisibility) {
        this.playerVisibility = playerVisibility;
    }

    @Generated
    public void setAllowSpectators(boolean allowSpectators) {
        this.allowSpectators = allowSpectators;
    }

    @Generated
    public void setAllowDuels(boolean allowDuels) {
        this.allowDuels = allowDuels;
    }

    @Generated
    public void setAllowParty(boolean allowParty) {
        this.allowParty = allowParty;
    }

    @Generated
    public void setMaxPing(int maxPing) {
        this.maxPing = maxPing;
    }

    @Generated
    public void setKillEffect(KillEffect killEffect) {
        this.killEffect = killEffect;
    }

    @Generated
    public void setMenuSound(boolean menuSound) {
        this.menuSound = menuSound;
    }

    @Generated
    public void setKillMessagePackage(KillMessagePackage killMessagePackage) {
        this.killMessagePackage = killMessagePackage;
    }

    @Generated
    public void setFollowings(List<UUID> followings) {
        this.followings = followings;
    }
}

