/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile.data;

import dev.lrxh.api.profile.IProfileState;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Visibility {
    private final UUID uuid;

    public Visibility(UUID playerUUID) {
        this.uuid = playerUUID;
        this.handle(playerUUID);
    }

    public void handle() {
        for (Player players : Bukkit.getOnlinePlayers()) {
            this.handle(players.getUniqueId());
        }
    }

    public void handle(UUID otherUUID) {
        Player viewerPlayer = Bukkit.getPlayer((UUID)this.uuid);
        Player otherPlayer = Bukkit.getPlayer((UUID)otherUUID);
        if (viewerPlayer == null || otherPlayer == null || viewerPlayer.equals((Object)otherPlayer)) {
            return;
        }
        Profile viewerProfile = API.getProfile(this.uuid);
        Profile otherProfile = API.getProfile(otherUUID);
        if (viewerProfile.hasState((IProfileState)ProfileState.IN_LOBBY)) {
            if (!viewerProfile.getSettingData().isPlayerVisibility()) {
                viewerPlayer.hidePlayer((Plugin)Neptune.get(), otherPlayer);
                return;
            }
            viewerPlayer.showPlayer((Plugin)Neptune.get(), otherPlayer);
        }
        if (viewerProfile.hasState((IProfileState)ProfileState.IN_LOBBY)) {
            if (!otherProfile.getSettingData().isPlayerVisibility()) {
                otherPlayer.hidePlayer((Plugin)Neptune.get(), viewerPlayer);
                return;
            }
            otherPlayer.showPlayer((Plugin)Neptune.get(), viewerPlayer);
        }
        if (viewerProfile.hasState((IProfileState)ProfileState.IN_KIT_EDITOR)) {
            viewerPlayer.hidePlayer((Plugin)Neptune.get(), otherPlayer);
            otherPlayer.hidePlayer((Plugin)Neptune.get(), viewerPlayer);
            return;
        }
        if (otherProfile.hasState((IProfileState)ProfileState.IN_KIT_EDITOR)) {
            otherPlayer.hidePlayer((Plugin)Neptune.get(), viewerPlayer);
            viewerPlayer.hidePlayer((Plugin)Neptune.get(), otherPlayer);
        }
    }

    public boolean has(Profile viewerProfile, Profile otherProfile, ProfileState ... states) {
        return viewerProfile.hasState(states) && otherProfile.hasState(states);
    }
}

