/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.profile.impl;

import dev.lrxh.api.profile.IProfile;
import dev.lrxh.api.profile.IProfileState;
import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MessagesLocale;
import dev.lrxh.neptune.feature.cosmetics.CosmeticService;
import dev.lrxh.neptune.feature.cosmetics.impl.KillEffect;
import dev.lrxh.neptune.feature.divisions.DivisionService;
import dev.lrxh.neptune.feature.hotbar.HotbarService;
import dev.lrxh.neptune.feature.party.Party;
import dev.lrxh.neptune.feature.party.PartyService;
import dev.lrxh.neptune.game.arena.procedure.ArenaProcedure;
import dev.lrxh.neptune.game.duel.DuelRequest;
import dev.lrxh.neptune.game.kit.Kit;
import dev.lrxh.neptune.game.kit.KitService;
import dev.lrxh.neptune.game.kit.procedure.KitProcedure;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.profile.data.GameData;
import dev.lrxh.neptune.profile.data.KitData;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.data.SettingData;
import dev.lrxh.neptune.profile.data.Visibility;
import dev.lrxh.neptune.providers.clickable.ClickableComponent;
import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.providers.database.DatabaseService;
import dev.lrxh.neptune.providers.database.impl.DataDocument;
import dev.lrxh.neptune.utils.Cooldown;
import dev.lrxh.neptune.utils.ItemUtils;
import dev.lrxh.neptune.utils.PlayerUtil;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class Profile
implements IProfile {
    private final UUID playerUUID;
    private Map<String, Cooldown> cooldowns;
    private String username;
    private ProfileState state;
    private String customState;
    private Neptune plugin;
    private GameData gameData;
    private SettingData settingData;
    private Visibility visibility;
    private ArenaProcedure arenaProcedure;
    private KitProcedure kitProcedure;
    private boolean fake;

    public Profile(String name, UUID uuid, Neptune plugin, boolean fake) {
        this.plugin = plugin;
        this.username = name;
        this.playerUUID = uuid;
        this.state = ProfileState.IN_LOBBY;
        this.gameData = new GameData(this);
        this.settingData = new SettingData(plugin);
        this.visibility = new Visibility(this.playerUUID);
        this.arenaProcedure = new ArenaProcedure();
        this.kitProcedure = new KitProcedure();
        this.fake = fake;
        this.cooldowns = new HashMap<String, Cooldown>();
    }

    public static CompletableFuture<Profile> create(String name, UUID uuid, Neptune plugin, boolean fake) {
        Profile profile = new Profile(name, uuid, plugin, fake);
        return Profile.load(profile);
    }

    public static CompletableFuture<Profile> load(Profile profile) {
        return DatabaseService.get().getDatabase().getUserData(profile.getPlayerUUID()).thenApply(dataDocument -> {
            if (dataDocument == null) {
                Profile.save(profile);
                return profile;
            }
            GameData gameData = profile.getGameData();
            SettingData settingData = profile.getSettingData();
            gameData.setMatchHistories(gameData.deserializeHistory(dataDocument.getList("history", new ArrayList<String>())));
            DataDocument kitStatistics = dataDocument.getDataDocument("kitData");
            DataDocument settings = dataDocument.getDataDocument("settings");
            for (Kit kit : KitService.get().kits) {
                DataDocument kitDocument = kitStatistics.getDataDocument(kit.getName());
                if (kitDocument == null) continue;
                KitData profileKitData = gameData.get(kit);
                profileKitData.setCurrentStreak(kitDocument.getInteger("WIN_STREAK_CURRENT", 0));
                profileKitData.setKills(kitDocument.getInteger("WINS", 0));
                profileKitData.setElo(kitDocument.getInteger("ELO", 0));
                profileKitData.setDivision(DivisionService.get().getDivisionByElo(profileKitData.getElo()));
                profileKitData.setDeaths(kitDocument.getInteger("LOSSES", 0));
                profileKitData.setBestStreak(kitDocument.getInteger("WIN_STREAK_BEST", 0));
                profileKitData.setKitLoadout(Objects.equals(kitDocument.getString("kit"), "") ? kit.getItems() : ItemUtils.deserialize(kitDocument.getString("kit")));
                DataDocument customPersistentData = kitDocument.getDataDocument("customPersistentData");
                if (customPersistentData != null) {
                    for (String key : customPersistentData.data.keySet()) {
                        profileKitData.setPersistentData(key, customPersistentData.data.get(key));
                    }
                }
                profileKitData.updateDivision();
            }
            gameData.setLastPlayedKit(kitStatistics.getString("lastPlayedKit", ""));
            settingData.setPlayerVisibility(settings.getBoolean("showPlayers", true));
            settingData.setAllowSpectators(settings.getBoolean("allowSpectators", true));
            settingData.setAllowDuels(settings.getBoolean("allowDuels", true));
            settingData.setAllowParty(settings.getBoolean("allowParty", true));
            settingData.setMaxPing(settings.getInteger("maxPing", 350));
            settingData.setKillEffect(KillEffect.valueOf(settings.getString("killEffect", "NONE")));
            settingData.setMenuSound(settings.getBoolean("menuSound", false));
            settingData.setKillMessagePackage(CosmeticService.get().getDeathMessagePackage(settings.getString("deathMessagePackage")));
            gameData.getGlobalStats().update();
            return profile;
        });
    }

    public static CompletableFuture<Void> save(Profile profile) {
        return CompletableFuture.runAsync(() -> {
            GameData gameData = profile.getGameData();
            SettingData settingData = profile.getSettingData();
            DataDocument dataDocument = new DataDocument();
            dataDocument.put("uuid", profile.getPlayerUUID().toString());
            dataDocument.put("username", profile.getUsername());
            dataDocument.put("history", gameData.serializeHistory());
            DataDocument kitStatsDoc = new DataDocument();
            for (Kit kit : KitService.get().kits) {
                DataDocument kitStatisticsDocument = new DataDocument();
                KitData entry = gameData.get(kit);
                kitStatisticsDocument.put("WIN_STREAK_CURRENT", entry.getCurrentStreak());
                kitStatisticsDocument.put("WINS", entry.getKills());
                kitStatisticsDocument.put("ELO", entry.getElo());
                kitStatisticsDocument.put("LOSSES", entry.getDeaths());
                kitStatisticsDocument.put("WIN_STREAK_BEST", entry.getBestStreak());
                kitStatisticsDocument.put("kit", entry.getKitLoadout() == null || entry.getKitLoadout().isEmpty() ? "" : ItemUtils.serialize(entry.getKitLoadout()));
                entry.updateDivision();
                DataDocument customPersistentData = new DataDocument();
                for (String key : entry.getPersistentData().keySet()) {
                    customPersistentData.put(key, entry.getPersistentData().get(key));
                }
                kitStatisticsDocument.put("customPersistentData", customPersistentData);
                kitStatsDoc.put(kit.getName(), kitStatisticsDocument);
            }
            kitStatsDoc.put("lastPlayedKit", gameData.getLastPlayedKit());
            dataDocument.put("kitData", kitStatsDoc);
            DataDocument settingsDoc = new DataDocument();
            settingsDoc.put("showPlayers", settingData.isPlayerVisibility());
            settingsDoc.put("allowSpectators", settingData.isAllowSpectators());
            settingsDoc.put("allowDuels", settingData.isAllowDuels());
            settingsDoc.put("allowParty", settingData.isAllowParty());
            settingsDoc.put("maxPing", settingData.getMaxPing());
            settingsDoc.put("killEffect", settingData.getKillEffect().toString());
            settingsDoc.put("menuSound", settingData.isMenuSound());
            settingsDoc.put("deathMessagePackage", settingData.getKillMessagePackage().getName());
            dataDocument.put("settings", settingsDoc);
            DataDocument globalCustomPersistentData = new DataDocument();
            for (String key : gameData.getPersistentData().keySet()) {
                globalCustomPersistentData.put(key, gameData.getPersistentData().get(key));
            }
            dataDocument.put("customPersistentData", globalCustomPersistentData);
            DatabaseService.get().getDatabase().replace(profile.getPlayerUUID(), dataDocument);
        });
    }

    public void handleVisibility() {
        this.visibility.handle();
    }

    public void setState(ProfileState profileState) {
        this.state = profileState;
        this.customState = "";
        this.handleVisibility();
        HotbarService.get().giveItems(this.getPlayer());
    }

    @Override
    public void setState(String customState) {
        this.customState = "";
        switch (customState) {
            case "neptune:in_lobby": {
                this.state = ProfileState.IN_LOBBY;
                break;
            }
            case "neptune:in_game": {
                this.state = ProfileState.IN_GAME;
                break;
            }
            case "neptune:in_kiteditor": {
                this.state = ProfileState.IN_KIT_EDITOR;
                break;
            }
            case "neptune:in_party": {
                this.state = ProfileState.IN_PARTY;
                break;
            }
            case "neptune:spectating": {
                this.state = ProfileState.IN_SPECTATOR;
                break;
            }
            case "neptune:in_queue": {
                this.state = ProfileState.IN_QUEUE;
                break;
            }
            default: {
                this.state = ProfileState.IN_CUSTOM;
                this.customState = customState;
            }
        }
        this.handleVisibility();
    }

    @Override
    public void toLobby() {
        this.setState(ProfileState.IN_LOBBY);
        PlayerUtil.teleportToSpawn(this.playerUUID);
        if (this.getMatch() != null) {
            this.getMatch().onDeath(this.getMatch().getParticipant(this.playerUUID));
        }
        this.getPlayer().setHealth(20.0);
    }

    public boolean hasState(IProfileState state) {
        return this.state.equals(state);
    }

    @Override
    public boolean hasState(String customState) {
        if (this.state != ProfileState.IN_CUSTOM) {
            return switch (customState) {
                case "neptune:in_lobby" -> {
                    if (this.state == ProfileState.IN_LOBBY) {
                        yield true;
                    }
                    yield false;
                }
                case "neptune:in_game" -> {
                    if (this.state == ProfileState.IN_GAME) {
                        yield true;
                    }
                    yield false;
                }
                case "neptune:in_kiteditor" -> {
                    if (this.state == ProfileState.IN_KIT_EDITOR) {
                        yield true;
                    }
                    yield false;
                }
                case "neptune:in_party" -> {
                    if (this.state == ProfileState.IN_PARTY) {
                        yield true;
                    }
                    yield false;
                }
                case "neptune:spectating" -> {
                    if (this.state == ProfileState.IN_SPECTATOR) {
                        yield true;
                    }
                    yield false;
                }
                case "neptune:in_queue" -> {
                    if (this.state == ProfileState.IN_QUEUE) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return this.customState.equals(customState);
    }

    @Override
    public String getProfileState() {
        if (this.state != ProfileState.IN_CUSTOM) {
            return switch (this.state) {
                case ProfileState.IN_LOBBY -> "neptune:in_lobby";
                case ProfileState.IN_GAME -> "neptune:in_game";
                case ProfileState.IN_KIT_EDITOR -> "neptune:in_kiteditor";
                case ProfileState.IN_PARTY -> "neptune:in_party";
                case ProfileState.IN_SPECTATOR -> "neptune:spectating";
                case ProfileState.IN_QUEUE -> "neptune:in_queue";
                default -> "neptune:unknown";
            };
        }
        return this.customState != null && !this.customState.isEmpty() ? this.customState : "neptune:unknown";
    }

    public boolean hasState(ProfileState ... profileStates) {
        for (ProfileState profileState : profileStates) {
            if (!profileState.equals(this.state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addCooldown(String name, int millis) {
        Cooldown cooldown = new Cooldown(millis);
        this.cooldowns.put(name, cooldown);
        cooldown.start();
    }

    public void addCooldown(String name, int millis, NeptuneRunnable runnable) {
        Cooldown cooldown = new Cooldown(millis, runnable);
        this.cooldowns.put(name, cooldown);
        cooldown.start();
    }

    @Override
    public boolean hasCooldownEnded(String name) {
        if (!this.cooldowns.containsKey(name)) {
            return true;
        }
        if (this.cooldowns.get(name).isExpired()) {
            this.cooldowns.remove(name);
            return true;
        }
        return false;
    }

    @Override
    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.playerUUID);
    }

    public void sendDuel(DuelRequest duelRequest) {
        UUID senderUUID = duelRequest.getSender();
        Player sender = Bukkit.getPlayer((UUID)senderUUID);
        if (sender == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUUID);
        if (player == null) {
            return;
        }
        MessagesLocale.DUEL_REQUEST_SENDER.send(sender.getUniqueId(), new Replacement("<receiver>", this.username), new Replacement("<kit>", duelRequest.getKit().getDisplayName()), new Replacement("<rounds>", String.valueOf(duelRequest.getRounds())), new Replacement("<arena>", duelRequest.getArena().getDisplayName()));
        this.gameData.addRequest(duelRequest, senderUUID, ignore -> {
            MessagesLocale.DUEL_EXPIRED.send(senderUUID, new Replacement("<player>", player.getName()));
            duelRequest.getArena().remove();
        });
        TextComponent accept = new ClickableComponent(MessagesLocale.DUEL_ACCEPT.getString(), "/duel accept-uuid " + duelRequest.getSender().toString(), MessagesLocale.DUEL_ACCEPT_HOVER.getString()).build();
        TextComponent deny = new ClickableComponent(MessagesLocale.DUEL_DENY.getString(), "/duel deny-uuid " + duelRequest.getSender().toString(), MessagesLocale.DUEL_DENY_HOVER.getString()).build();
        MessagesLocale.DUEL_REQUEST_RECEIVER.send(this.playerUUID, new Replacement("<accept>", accept), new Replacement("<deny>", deny), new Replacement("<kit>", duelRequest.getKit().getDisplayName()), new Replacement("<arena>", duelRequest.getArena().getDisplayName()), new Replacement("<rounds>", String.valueOf(duelRequest.getRounds())), new Replacement("<sender>", sender.getName()));
    }

    public void sendRematch(DuelRequest duelRequest) {
        UUID senderUUID = duelRequest.getSender();
        Player sender = Bukkit.getPlayer((UUID)senderUUID);
        if (sender == null) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUUID);
        if (player == null) {
            return;
        }
        MessagesLocale.REMATCH_REQUEST_SENDER.send(sender.getUniqueId(), new Replacement("<receiver>", this.username), new Replacement("<arena>", duelRequest.getArena().getDisplayName()));
        this.gameData.addRequest(duelRequest, senderUUID, ignore -> MessagesLocale.REMATCH_EXPIRED.send(senderUUID, new Replacement("<player>", player.getName())));
        TextComponent accept = new ClickableComponent(MessagesLocale.REMATCH_ACCEPT.getString(), "/duel accept-uuid " + duelRequest.getSender().toString(), MessagesLocale.REMATCH_ACCEPT_HOVER.getString()).build();
        TextComponent deny = new ClickableComponent(MessagesLocale.REMATCH_DENY.getString(), "/duel accept-uuid " + duelRequest.getSender().toString(), MessagesLocale.REMATCH_DENY_HOVER.getString()).build();
        MessagesLocale.REMATCH_REQUEST_RECEIVER.send(this.playerUUID, new Replacement("<accept>", accept), new Replacement("<deny>", deny), new Replacement("<kit>", duelRequest.getKit().getDisplayName()), new Replacement("<arena>", duelRequest.getArena().getDisplayName()), new Replacement("<rounds>", String.valueOf(duelRequest.getRounds())), new Replacement("<sender>", sender.getName()));
    }

    public Party createParty() {
        if (this.gameData.getParty() != null) {
            MessagesLocale.PARTY_ALREADY_IN.send(this.playerUUID, new Replacement[0]);
            return null;
        }
        Party party = new Party(this.playerUUID, this.getPartyLimit(), this.plugin);
        PartyService.get().addParty(party);
        API.getProfile(this.playerUUID).getGameData().setParty(party);
        MessagesLocale.PARTY_CREATE.send(this.playerUUID, new Replacement[0]);
        return party;
    }

    public void disband() {
        Party party = this.gameData.getParty();
        if (party == null) {
            return;
        }
        party.broadcast(MessagesLocale.PARTY_LEFT, new Replacement("<player>", this.username));
        party.remove(this.playerUUID);
    }

    public void acceptDuel(UUID senderUUID) {
        ((DuelRequest)this.gameData.getRequests().get(senderUUID)).start(this.playerUUID);
        this.gameData.removeRequest(senderUUID);
    }

    public int getPartyLimit() {
        int max = 10;
        for (PermissionAttachmentInfo perm : this.getPlayer().getEffectivePermissions()) {
            String permission = perm.getPermission();
            if (!permission.startsWith("neptune.party.max.")) continue;
            try {
                int value = Integer.parseInt(permission.substring("neptune.party.max.".length()));
                if (value <= max) continue;
                max = value;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max;
    }

    public Match getMatch() {
        return this.gameData.getMatch();
    }

    public void setMatch(Match match) {
        this.gameData.setMatch(match);
    }

    @Override
    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    @Generated
    public Map<String, Cooldown> getCooldowns() {
        return this.cooldowns;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public ProfileState getState() {
        return this.state;
    }

    @Generated
    public String getCustomState() {
        return this.customState;
    }

    @Generated
    public Neptune getPlugin() {
        return this.plugin;
    }

    @Override
    @Generated
    public GameData getGameData() {
        return this.gameData;
    }

    @Generated
    public SettingData getSettingData() {
        return this.settingData;
    }

    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Generated
    public ArenaProcedure getArenaProcedure() {
        return this.arenaProcedure;
    }

    @Generated
    public KitProcedure getKitProcedure() {
        return this.kitProcedure;
    }

    @Generated
    public boolean isFake() {
        return this.fake;
    }

    @Generated
    public void setCooldowns(Map<String, Cooldown> cooldowns) {
        this.cooldowns = cooldowns;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setCustomState(String customState) {
        this.customState = customState;
    }

    @Generated
    public void setPlugin(Neptune plugin) {
        this.plugin = plugin;
    }

    @Generated
    public void setGameData(GameData gameData) {
        this.gameData = gameData;
    }

    @Generated
    public void setSettingData(SettingData settingData) {
        this.settingData = settingData;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setArenaProcedure(ArenaProcedure arenaProcedure) {
        this.arenaProcedure = arenaProcedure;
    }

    @Generated
    public void setKitProcedure(KitProcedure kitProcedure) {
        this.kitProcedure = kitProcedure;
    }

    @Generated
    public void setFake(boolean fake) {
        this.fake = fake;
    }
}

