/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.providers.database;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.SettingsLocale;
import dev.lrxh.neptune.providers.database.impl.DatabaseType;
import dev.lrxh.neptune.providers.database.impl.IDatabase;
import dev.lrxh.neptune.utils.ServerUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DatabaseService {
    private static DatabaseService instance;
    private final ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
    private IDatabase database = null;

    public DatabaseService() {
        String uri = SettingsLocale.URI.getString();
        if (uri != null && (uri.isEmpty() || uri.equals("NONE")) && !SettingsLocale.DATABASE_TYPE.getString().equalsIgnoreCase("SQLITE")) {
            ServerUtils.error("URI is missing or empty");
            Bukkit.getPluginManager().disablePlugin((Plugin)Neptune.get());
        }
        try {
            this.database = DatabaseType.valueOf(SettingsLocale.DATABASE_TYPE.getString()).getIDatabase().load();
        }
        catch (RuntimeException e) {
            ServerUtils.error("Unknown database type in settings.yml");
        }
    }

    public static DatabaseService get() {
        if (instance == null) {
            instance = new DatabaseService();
        }
        return instance;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public IDatabase getDatabase() {
        return this.database;
    }
}

