/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.providers.database.impl;

import com.google.gson.JsonParseException;
import dev.lrxh.neptune.utils.ServerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;

public class DataDocument {
    public Map<String, Object> data = new HashMap<String, Object>();

    public DataDocument() {
    }

    public DataDocument(Document document) {
        for (String key : document.keySet()) {
            Object value = document.get((Object)key);
            if (value instanceof Document) {
                this.data.put(key, new DataDocument((Document)value));
                continue;
            }
            this.data.put(key, value);
        }
    }

    public DataDocument(String jsonString) {
        try {
            Document document = Document.parse((String)jsonString);
            for (String key : document.keySet()) {
                Object value = document.get((Object)key);
                if (value instanceof Document) {
                    this.data.put(key, new DataDocument((Document)value));
                    continue;
                }
                this.data.put(key, value);
            }
        }
        catch (JsonParseException e) {
            ServerUtils.error("Invalid JSON string: " + jsonString);
            throw e;
        }
    }

    public Document toDocument() {
        Document document = new Document();
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            if (entry.getValue() instanceof DataDocument) {
                document.put(entry.getKey(), (Object)((DataDocument)entry.getValue()).toDocument());
                continue;
            }
            document.put(entry.getKey(), entry.getValue());
        }
        return document;
    }

    public int getInteger(String key, int defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    public String getString(String key, String defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public String getString(String key) {
        Object value = this.data.get(key);
        return (String)value;
    }

    public List<String> getList(String key, List<String> defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (List)value;
    }

    public DataDocument getDataDocument(String key) {
        DataDocument value = (DataDocument)this.data.get(key);
        if (value == null) {
            this.data.put(key, new DataDocument());
        }
        return (DataDocument)this.data.get(key);
    }

    public void put(String key, Object value) {
        this.data.put(key, value);
    }
}

