/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.providers.database.impl;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.providers.database.impl.DataDocument;
import dev.lrxh.neptune.providers.database.impl.IDatabase;
import dev.lrxh.neptune.utils.ServerUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SQLiteDatabase
implements IDatabase {
    private static final String SQL_CREATE_TABLE = "CREATE TABLE IF NOT EXISTS playerData (uuid VARCHAR(36) NOT NULL PRIMARY KEY, data TEXT NOT NULL)";
    private static final String SQL_UPSERT = "INSERT INTO playerData(uuid, data) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET data = excluded.data";
    private final String dbPath = "jdbc:sqlite:" + String.valueOf(Neptune.get().getDataFolder()) + "/neptune.db";
    private final ExecutorService dbExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "neptune-sqlite-db");
        t.setDaemon(true);
        return t;
    });
    private Connection connection;

    @Override
    public IDatabase load() {
        try {
            this.connection = DriverManager.getConnection(this.dbPath);
            Future<?> initFuture = this.dbExecutor.submit(() -> {
                this.configureConnectionPragmas();
                this.createTableIfNotExists();
            });
            initFuture.get();
        }
        catch (InterruptedException | SQLException | ExecutionException e) {
            ServerUtils.error("Failed to connect / initialize SQLite database: " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)Neptune.get());
        }
        return this;
    }

    private void configureConnectionPragmas() {
        try (Statement s = this.connection.createStatement();){
            s.execute("PRAGMA journal_mode = WAL;");
            s.execute("PRAGMA synchronous = NORMAL;");
            s.execute("PRAGMA temp_store = MEMORY;");
            s.execute("PRAGMA cache_size = 10000;");
            s.execute("PRAGMA foreign_keys = ON;");
        }
        catch (SQLException e) {
            ServerUtils.error("Failed to apply SQLite pragmas: " + e.getMessage());
        }
    }

    private void ensureConnectionOpen() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connection = DriverManager.getConnection(this.dbPath);
            this.configureConnectionPragmas();
        }
    }

    private void createTableIfNotExists() {
        try {
            this.ensureConnectionOpen();
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute(SQL_CREATE_TABLE);
            }
        }
        catch (SQLException e) {
            ServerUtils.error("Error creating playerData table: " + e.getMessage());
        }
    }

    public CompletableFuture<List<Map<String, Object>>> queryData(String sql) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList results = new ArrayList();
            try {
                this.ensureConnectionOpen();
                try (Statement stmt = this.connection.createStatement();
                     ResultSet rs = stmt.executeQuery(sql);){
                    ResultSetMetaData meta = rs.getMetaData();
                    int columnCount = meta.getColumnCount();
                    while (rs.next()) {
                        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>(columnCount);
                        for (int i = 1; i <= columnCount; ++i) {
                            row.put(meta.getColumnName(i), rs.getObject(i));
                        }
                        results.add(row);
                    }
                }
            }
            catch (SQLException e) {
                ServerUtils.error("Error executing query on SQLite: " + e.getMessage());
                throw new RuntimeException(e);
            }
            return results;
        }, this.dbExecutor);
    }

    public CompletableFuture<Integer> executeUpdate(String sql, Object ... params) {
        return CompletableFuture.supplyAsync(() -> {
            Integer n;
            block9: {
                this.ensureConnectionOpen();
                PreparedStatement ps = this.connection.prepareStatement(sql);
                try {
                    for (int i = 0; i < params.length; ++i) {
                        ps.setObject(i + 1, params[i]);
                    }
                    n = ps.executeUpdate();
                    if (ps == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        ServerUtils.error("Error executing update on SQLite: " + e.getMessage());
                        throw new RuntimeException(e);
                    }
                }
                ps.close();
            }
            return n;
        }, this.dbExecutor);
    }

    @Override
    public CompletableFuture<DataDocument> getUserData(UUID playerUUID) {
        return this.queryData("SELECT data FROM playerData WHERE uuid = '" + String.valueOf(playerUUID) + "'").thenApply(list -> {
            if (list.isEmpty()) {
                return null;
            }
            String dataString = (String)((Map)list.get(0)).get("data");
            return new DataDocument(dataString);
        });
    }

    @Override
    public CompletableFuture<Void> replace(UUID playerUUID, DataDocument newDocument) {
        return this.executeUpdate(SQL_UPSERT, playerUUID.toString(), newDocument.toDocument().toJson()).thenApply(ignored -> null);
    }

    @Override
    public CompletableFuture<Void> replace(String playerUUID, DataDocument newDocument) {
        return this.executeUpdate(SQL_UPSERT, playerUUID, newDocument.toDocument().toJson()).thenApply(ignored -> null);
    }

    @Override
    public CompletableFuture<List<DataDocument>> getAllByKitType(String kitName, String type) {
        String sql = "SELECT data FROM playerData WHERE json_extract(data, '$.kitData.\"" + kitName + "\"." + type + "') IS NOT NULL AND json_extract(data, '$.kitData.\"" + kitName + "\"." + type + "') > 0 ORDER BY CAST(json_extract(data, '$.kitData.\"" + kitName + "\"." + type + "') AS INTEGER) DESC";
        return this.queryData(sql).thenApply(resultList -> {
            ArrayList<DataDocument> results = new ArrayList<DataDocument>();
            for (Map row : resultList) {
                String jsonString = (String)row.get("data");
                if (jsonString == null) continue;
                results.add(new DataDocument(jsonString));
            }
            return results;
        });
    }
}

