/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.providers.listeners;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.CC;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.projectiles.ProjectileSource;

public class GlobalListener
implements Listener {
    private boolean isPlayerNotInMatch(Profile profile) {
        if (profile == null) {
            return true;
        }
        ProfileState state = profile.getState();
        return !state.equals(ProfileState.IN_GAME) && !state.equals(ProfileState.IN_SPECTATOR) || profile.getMatch() == null;
    }

    @EventHandler
    public void onCreatureSpawnEvent(CreatureSpawnEvent event) {
        if (event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER_EGG) || event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.BUCKET)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (event.getInventory().getType() == InventoryType.CRAFTING) {
            HumanEntity humanEntity = event.getWhoClicked();
            if (!(humanEntity instanceof Player)) {
                return;
            }
            Player player = (Player)humanEntity;
            if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                return;
            }
            Profile profile = API.getProfile(player);
            if (this.isPlayerNotInMatch(profile) && profile.getState() != ProfileState.IN_CUSTOM) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onShiftRightClick(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (entity instanceof Player) {
            Player clicked = (Player)entity;
            if (!player.isSneaking()) {
                return;
            }
            player.chat("/duel " + clicked.getName());
        }
    }

    @EventHandler
    public void onWeatherChange(WeatherChangeEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onHangingBreak(HangingBreakEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onBlockSpread(BlockSpreadEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onMoistureChange(MoistureChangeEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onSoilChange(PlayerInteractEvent event) {
        Profile profile = API.getProfile(event.getPlayer());
        if (profile != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        if (event.getAction() == Action.PHYSICAL && Objects.requireNonNull(event.getClickedBlock()).getType() == Material.FARMLAND) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Profile profile = API.getProfile(player);
        if (this.isPlayerNotInMatch(profile) && profile.getState() != ProfileState.IN_CUSTOM) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Profile profile = API.getProfile(player);
        if (profile != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        if (profile.getState().equals(ProfileState.IN_SPECTATOR)) {
            event.setCancelled(true);
        }
        if (this.isPlayerNotInMatch(profile)) {
            event.setCancelled(true);
            if (profile != null) {
                ProfileState state = profile.getState();
                if (state.equals(ProfileState.IN_KIT_EDITOR)) {
                    player.sendMessage((Component)CC.color("&cYou can't break blocks in the kit editor!"));
                } else if (state.equals(ProfileState.IN_QUEUE)) {
                    player.sendMessage((Component)CC.color("&cYou can't break blocks while in queue!"));
                } else {
                    player.sendMessage((Component)CC.color("&cYou can't break blocks here!"));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Profile profile = API.getProfile(player);
        if (profile != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        if (this.isPlayerNotInMatch(profile)) {
            event.setCancelled(true);
            player.sendMessage((Component)CC.color("&cYou can't place liquids here!"));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        if (event.getItemDrop().getItemStack().getType().equals((Object)Material.GLASS_BOTTLE)) {
            event.getItemDrop().remove();
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Profile profile = API.getProfile(player);
        if (profile != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        if (this.isPlayerNotInMatch(profile)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                return;
            }
            Profile profile = API.getProfile(player);
            if (profile != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
                return;
            }
            if (this.isPlayerNotInMatch(profile)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDamageByPlayer(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (entity instanceof Player) {
            Player attacker = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof Player) {
                Player victim = (Player)entity;
                Profile attackerProfile = API.getProfile(attacker);
                Profile victimProfile = API.getProfile(victim);
                if (attackerProfile != null && attackerProfile.getState().equals(ProfileState.IN_CUSTOM)) {
                    return;
                }
                if (victimProfile != null && victimProfile.getState().equals(ProfileState.IN_CUSTOM)) {
                    return;
                }
                if (this.isPlayerNotInMatch(attackerProfile) || this.isPlayerNotInMatch(victimProfile)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Profile profile = API.getProfile(player);
            if (profile == null) {
                return;
            }
            if (profile.getState().equals(ProfileState.IN_CUSTOM)) {
                return;
            }
            if (this.isPlayerNotInMatch(profile)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        HumanEntity humanEntity = event.getEntity();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            Profile profile = API.getProfile(player);
            if (profile == null) {
                return;
            }
            if (profile.getState().equals(ProfileState.IN_CUSTOM)) {
                return;
            }
            if (this.isPlayerNotInMatch(profile) && profile.getState() != ProfileState.IN_CUSTOM) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onProjectileHit(ProjectileHitEvent event) {
        ProjectileSource projectileSource = event.getEntity().getShooter();
        if (projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                return;
            }
            Profile profile = API.getProfile(player);
            if (profile != null && profile.getState().equals(ProfileState.IN_CUSTOM)) {
                return;
            }
            if (this.isPlayerNotInMatch(profile)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPotionEffect(EntityPotionEffectEvent event) {
        PotionEffect oldEffect;
        PotionEffect newEffect;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (API.getProfile(player) != null && API.getProfile(player).getState().equals(ProfileState.IN_CUSTOM)) {
            return;
        }
        if (event.getAction() == EntityPotionEffectEvent.Action.ADDED && (newEffect = event.getNewEffect()) != null) {
            player.setMetadata("max_duration_" + newEffect.getType().getName(), (MetadataValue)new FixedMetadataValue((Plugin)Neptune.get(), (Object)newEffect.getDuration()));
        }
        if ((event.getAction() == EntityPotionEffectEvent.Action.REMOVED || event.getAction() == EntityPotionEffectEvent.Action.CLEARED) && (oldEffect = event.getOldEffect()) != null) {
            player.removeMetadata("max_duration_" + oldEffect.getType().getName(), (Plugin)Neptune.get());
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        event.setRespawnLocation(player.getLocation());
    }
}

