/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.providers.placeholder;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.feature.party.Party;
import dev.lrxh.neptune.feature.queue.QueueEntry;
import dev.lrxh.neptune.feature.queue.QueueService;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.MatchService;
import dev.lrxh.neptune.game.match.impl.ffa.FfaFightMatch;
import dev.lrxh.neptune.game.match.impl.participant.Participant;
import dev.lrxh.neptune.game.match.impl.solo.SoloFightMatch;
import dev.lrxh.neptune.game.match.impl.team.MatchTeam;
import dev.lrxh.neptune.game.match.impl.team.TeamFightMatch;
import dev.lrxh.neptune.profile.data.GlobalStats;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.PlayerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class PlaceholderUtil {
    public static List<String> format(List<String> lines, Player player) {
        ArrayList<String> formattedLines = new ArrayList<String>();
        for (String line : lines) {
            formattedLines.add(PlaceholderUtil.format(line, player));
        }
        return formattedLines;
    }

    public static Component format(Component component, Player player) {
        return component.replaceText(builder -> builder.match(Pattern.compile("<.*?>")).replacement((match, builder1) -> {
            String placeholder = match.group();
            String replacement = PlaceholderUtil.format(placeholder, player);
            return Component.text((String)replacement);
        }));
    }

    public static String format(String line, Player player) {
        Party party;
        Profile profile = API.getProfile(player);
        if (profile == null) {
            return line;
        }
        ProfileState state = profile.getState();
        line = line.replaceAll("<online>", String.valueOf(Bukkit.getServer().getOnlinePlayers().size()));
        line = line.replaceAll("<queued>", String.valueOf(QueueService.get().getQueueSize()));
        line = line.replaceAll("<in-match>", String.valueOf(MatchService.get().matches.size()));
        line = line.replaceAll("<player>", player.getName());
        line = line.replaceAll("<ping>", String.valueOf(PlayerUtil.getPing(player)));
        line = line.replaceAll("<division>", profile.getGameData().getGlobalStats().getDivision().getDisplayName());
        GlobalStats globalStats = profile.getGameData().getGlobalStats();
        line = line.replaceAll("<wins>", String.valueOf(globalStats.getWins()));
        line = line.replaceAll("<losses>", String.valueOf(globalStats.getLosses()));
        line = line.replaceAll("<currentStreak>", String.valueOf(globalStats.getCurrentStreak()));
        if (state.equals(ProfileState.IN_QUEUE)) {
            QueueEntry queueEntry = QueueService.get().get(player.getUniqueId());
            if (queueEntry == null) {
                return line;
            }
            line = line.replaceAll("<kit>", queueEntry.getKit().getDisplayName());
            line = line.replaceAll("<maxPing>", String.valueOf(profile.getSettingData().getMaxPing()));
            line = line.replaceAll("<time>", String.valueOf(queueEntry.getTime().formatTime()));
            line = line.replaceAll("<kit_division>", profile.getGameData().get(queueEntry.getKit()).getDivision().getDisplayName());
        }
        if (state.equals(ProfileState.IN_KIT_EDITOR)) {
            line = line.replaceAll("<kit>", profile.getGameData().getKitEditor().getDisplayName());
        }
        if ((party = profile.getGameData().getParty()) != null) {
            line = line.replaceAll("<leader>", party.getLeaderName());
            line = line.replaceAll("<size>", String.valueOf(party.getUsers().size()));
            line = line.replaceAll("<party-max>", String.valueOf(party.getMaxUsers()));
        }
        if (profile.getMatch() != null) {
            Match match = profile.getMatch();
            Participant participant = match.getParticipant(player.getUniqueId());
            line = line.replaceAll("<maxPoints>", String.valueOf(match.getRounds()));
            line = line.replaceAll("<kit_division>", profile.getGameData().get(profile.getMatch().getKit()).getDivision().getDisplayName());
            if (match instanceof SoloFightMatch) {
                SoloFightMatch soloFightMatch = (SoloFightMatch)match;
                Participant red = soloFightMatch.getParticipantA();
                Participant blue = soloFightMatch.getParticipantB();
                line = line.replaceAll("<red-hits>", String.valueOf(red.getHits()));
                line = line.replaceAll("<blue-hits>", String.valueOf(blue.getHits()));
                line = line.replaceAll("<red-combo>", (String)(red.getCombo() > 1 ? "&e(" + red.getCombo() + " Combo)" : ""));
                line = line.replaceAll("<blue-combo>", (String)(blue.getCombo() > 1 ? "&e(" + blue.getCombo() + " Combo)" : ""));
                line = line.replaceAll("<red-points>", String.valueOf(red.getPoints()));
                line = line.replaceAll("<blue-points>", String.valueOf(blue.getPoints()));
                line = line.replaceAll("<red-difference>", String.valueOf(red.getHitsDifference(blue)));
                line = line.replaceAll("<blue-difference>", String.valueOf(blue.getHitsDifference(red)));
                line = line.replaceAll("<playerRed_name>", red.getNameUnColored());
                line = line.replaceAll("<playerBlue_name>", blue.getNameUnColored());
                line = line.replaceAll("<playerRed_ping>", String.valueOf(PlayerUtil.getPing(red.getPlayer())));
                line = line.replaceAll("<playerBlue_ping>", String.valueOf(PlayerUtil.getPing(blue.getPlayer())));
                if (match.getKit().is(KitRule.BED_WARS)) {
                    line = line.replaceAll("<red-bed-status>", !red.isBedBroken() ? "&a\u2714" : "&c1");
                    line = line.replaceAll("<blue-bed-status>", !blue.isBedBroken() ? "&a\u2714" : "&c1");
                }
                if (participant != null) {
                    Participant opponent = participant.getOpponent();
                    Player opponentPlayer = participant.getOpponent().getPlayer();
                    line = line.replaceAll("<hits>", String.valueOf(participant.getHits()));
                    line = line.replaceAll("<combo>", (String)(participant.getCombo() > 1 ? "&e(" + participant.getCombo() + " Combo)" : ""));
                    line = line.replaceAll("<opponent>", participant.getOpponent().getNameUnColored());
                    line = line.replaceAll("<opponent-ping>", String.valueOf(opponentPlayer == null ? 0 : opponentPlayer.getPing()));
                    line = line.replaceAll("<opponent-combo>", (String)(opponent.getCombo() > 1 ? "&e(" + opponent.getCombo() + " Combo)" : ""));
                    line = line.replaceAll("<opponent-hits>", String.valueOf(opponent.getHits()));
                    line = line.replaceAll("<diffrence>", participant.getHitsDifference(opponent));
                    line = line.replaceAll("<difference>", participant.getHitsDifference(opponent));
                    line = line.replaceAll("<points>", String.valueOf(participant.getPoints()));
                    line = line.replaceAll("<opponent-points>", String.valueOf(opponent.getPoints()));
                    if (match.getKit().is(KitRule.BED_WARS)) {
                        line = line.replaceAll("<bed-status>", !participant.isBedBroken() ? "&a\u2714" : "&c1");
                        line = line.replaceAll("<opponent-bed-status>", !opponent.isBedBroken() ? "&a\u2714" : "&c1");
                    }
                }
            } else if (match instanceof TeamFightMatch) {
                TeamFightMatch teamFightMatch = (TeamFightMatch)match;
                MatchTeam redTeam = teamFightMatch.getTeamA();
                MatchTeam blueTeam = teamFightMatch.getTeamB();
                line = line.replaceAll("<alive-red>", String.valueOf(redTeam.getAliveParticipants()));
                line = line.replaceAll("<max-red>", String.valueOf(redTeam.getParticipants().size()));
                line = line.replaceAll("<alive-blue>", String.valueOf(blueTeam.getAliveParticipants()));
                line = line.replaceAll("<max-blue>", String.valueOf(blueTeam.getParticipants().size()));
                if (match.getKit().is(KitRule.BED_WARS)) {
                    line = line.replaceAll("<red-bed-status>", (String)(!redTeam.isBedBroken() ? "&a\u2714" : "&c" + redTeam.getAliveParticipants()));
                    line = line.replaceAll("<blue-bed-status>", (String)(!blueTeam.isBedBroken() ? "&a\u2714" : "&c" + blueTeam.getAliveParticipants()));
                }
                if (participant != null) {
                    MatchTeam matchTeam = teamFightMatch.getParticipantTeam(participant);
                    MatchTeam opponentTeam = teamFightMatch.getParticipantTeam(participant).getOpponentTeam();
                    line = line.replaceAll("<alive>", String.valueOf(matchTeam.getAliveParticipants()));
                    line = line.replaceAll("<max>", String.valueOf(matchTeam.getParticipants().size()));
                    line = line.replaceAll("<alive-opponent>", String.valueOf(opponentTeam.getAliveParticipants()));
                    line = line.replaceAll("<max-opponent>", String.valueOf(opponentTeam.getParticipants().size()));
                    if (match.getRounds() > 1) {
                        line = line.replaceAll("<points>", String.valueOf(matchTeam.getPoints()));
                        line = line.replaceAll("<opponent-points>", String.valueOf(opponentTeam.getPoints()));
                    }
                    if (match.getKit().is(KitRule.BED_WARS)) {
                        line = line.replaceAll("<team-bed-status>", (String)(!matchTeam.isBedBroken() ? "&a\u2714" : "&c" + matchTeam.getAliveParticipants()));
                        line = line.replaceAll("<opponent-team-bed-status>", (String)(!opponentTeam.isBedBroken() ? "&a\u2714" : "&c" + opponentTeam.getAliveParticipants()));
                    }
                }
            } else if (match instanceof FfaFightMatch) {
                FfaFightMatch ffaFightMatch = (FfaFightMatch)match;
                line = line.replaceAll("<alive>", String.valueOf(ffaFightMatch.getParticipants().size() - ffaFightMatch.deadParticipants.size()));
                line = line.replaceAll("<max>", String.valueOf(ffaFightMatch.getParticipants().size()));
            }
            line = line.replaceAll("<kit>", match.getKit().getDisplayName());
            line = line.replaceAll("<arena>", match.getArena().getDisplayName());
            line = line.replaceAll("<time>", match.getTime().formatTime());
        }
        if (Neptune.get().isPlaceholder() && PlaceholderAPIPlugin.getInstance().isEnabled()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)line);
        }
        return line;
    }

    @Generated
    private PlaceholderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

