/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.scoreboard;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.configs.impl.ScoreboardLocale;
import dev.lrxh.neptune.game.kit.impl.KitRule;
import dev.lrxh.neptune.game.match.Match;
import dev.lrxh.neptune.game.match.impl.ffa.FfaFightMatch;
import dev.lrxh.neptune.game.match.impl.solo.SoloFightMatch;
import dev.lrxh.neptune.game.match.impl.team.TeamFightMatch;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.providers.placeholder.PlaceholderUtil;
import dev.lrxh.neptune.scoreboard.ScoreboardService;
import fr.mrmicky.fastboard.FastAdapter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;

public class ScoreboardAdapter
implements FastAdapter {
    @Override
    public String getTitle(Player player) {
        return PlaceholderUtil.format(this.getAnimatedText(), player);
    }

    @Override
    public List<String> getLines(Player player) {
        Profile profile = API.getProfile(player);
        if (profile == null) {
            return new ArrayList<String>();
        }
        ProfileState state = profile.getState();
        switch (state) {
            case IN_LOBBY: {
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.LOBBY.getStringList()), player);
            }
            case IN_KIT_EDITOR: {
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.KIT_EDITOR.getStringList()), player);
            }
            case IN_PARTY: {
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.PARTY_LOBBY.getStringList()), player);
            }
            case IN_QUEUE: {
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_QUEUE.getStringList()), player);
            }
            case IN_GAME: {
                Match match = profile.getMatch();
                return match.getScoreboard(player.getUniqueId());
            }
            case IN_SPECTATOR: {
                Match match = profile.getMatch();
                if (match instanceof SoloFightMatch) {
                    if (match.getKit().is(KitRule.BED_WARS)) {
                        return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_SPECTATOR_BEDWARS.getStringList()), player);
                    }
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_SPECTATOR.getStringList()), player);
                }
                if (match instanceof TeamFightMatch) {
                    if (match.getKit().is(KitRule.BED_WARS)) {
                        return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_SPECTATOR_BEDWARS.getStringList()), player);
                    }
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_SPECTATOR_TEAM.getStringList()), player);
                }
                if (match instanceof FfaFightMatch) {
                    return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_SPECTATOR_FFA.getStringList()), player);
                }
                return PlaceholderUtil.format(new ArrayList<String>(ScoreboardLocale.IN_SPECTATOR.getStringList()), player);
            }
            case IN_CUSTOM: {
                return PlaceholderUtil.format(ScoreboardService.get().getScoreboardLines(profile.getCustomState(), profile), player);
            }
        }
        return new ArrayList<String>();
    }

    private String getAnimatedText() {
        int index = (int)(System.currentTimeMillis() / (long)ScoreboardLocale.UPDATE_INTERVAL.getInt() % (long)ScoreboardLocale.TITLE.getStringList().size());
        return ScoreboardLocale.TITLE.getStringList().get(index);
    }
}

