/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.utils.ServerUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import lombok.Generated;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigFile {
    private final File file;
    private final YamlConfiguration configuration;

    public ConfigFile(String name) {
        File dataFolder = new File(Neptune.get().getDataFolder().getParentFile(), "Neptune");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.file = new File(dataFolder, name + ".yml");
        if (!this.file.exists()) {
            try (InputStream in = Neptune.get().getResource(name + ".yml");){
                if (in != null) {
                    Files.copy(in, this.file.toPath(), new CopyOption[0]);
                } else if (!this.file.createNewFile()) {
                    throw new IOException("File was not created.");
                }
            }
            catch (IOException e) {
                ServerUtils.error("Error occurred creating config file: " + String.valueOf(e));
            }
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (IOException e) {
            ServerUtils.error("Error occurred saving config: " + String.valueOf(e));
        }
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }
}

