/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;

public class Cooldown {
    private final long durationMillis;
    private long startTime;

    public Cooldown(long durationMillis) {
        this.durationMillis = durationMillis;
        this.startTime = 0L;
    }

    public Cooldown(long durationMillis, NeptuneRunnable task) {
        this.durationMillis = durationMillis;
        this.startTime = 0L;
        task.startLater(durationMillis / 50L);
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.startTime >= this.durationMillis;
    }

    public long getRemainingTime() {
        long remaining = this.durationMillis - (System.currentTimeMillis() - this.startTime);
        return Math.max(remaining, 0L);
    }

    public String formatSecondsMillis() {
        long remaining = this.getRemainingTime();
        long seconds = remaining / 1000L;
        long millis = remaining % 1000L / 10L;
        return String.format("%02d.%02ds", seconds, millis);
    }

    public String formatMinutesSeconds() {
        long remaining = this.getRemainingTime();
        long minutes = remaining / 1000L / 60L;
        long seconds = remaining / 1000L % 60L;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public int getSecondsLeft() {
        return (int)Math.ceil((double)this.getRemainingTime() / 1000.0);
    }

    public float xp() {
        return (float)this.getRemainingTime() / (float)this.durationMillis;
    }

    public void reset() {
        this.start();
    }
}

