/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.utils.ServerUtils;
import java.io.InputStream;
import java.util.Properties;
import lombok.Generated;

public final class GithubUtils {
    private static String commitId = "UNKNOWN";
    private static String commitMessage = "UNKNOWN";

    public static void loadGitInfo() {
        try (InputStream input = GithubUtils.class.getClassLoader().getResourceAsStream("git.properties");){
            if (input != null) {
                Properties props = new Properties();
                props.load(input);
                commitId = props.getProperty("git.commit.id.abbrev", "UNKNOWN");
                commitMessage = props.getProperty("git.commit.message.short", "UNKNOWN");
                ServerUtils.info("Loaded Git info: " + commitId + " - " + commitMessage);
            } else {
                ServerUtils.info("git.properties not found in resources!");
            }
        }
        catch (Exception e) {
            ServerUtils.error("Failed to load git.properties: " + e.getMessage());
        }
    }

    public static String getCommitId() {
        return commitId;
    }

    public static String getCommitMessage() {
        return commitMessage;
    }

    @Generated
    private GithubUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

