/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.providers.material.NMaterial;
import dev.lrxh.neptune.providers.placeholder.PlaceholderUtil;
import dev.lrxh.neptune.utils.CC;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder {
    private final ItemStack item;

    public ItemBuilder(Material material) {
        this.item = new ItemStack(Objects.requireNonNullElse(material, Material.AIR));
    }

    public ItemBuilder(String material) {
        this.item = new ItemStack(Objects.requireNonNullElse(Material.valueOf((String)material), Material.AIR));
    }

    public ItemBuilder(String material, UUID playerUUID) {
        NMaterial nMaterial = null;
        try {
            nMaterial = NMaterial.valueOf(material);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        this.item = nMaterial != null && player != null ? nMaterial.getItem(player) : (material != null ? new ItemStack(Objects.requireNonNullElse(Material.valueOf((String)material), Material.AIR)) : new ItemStack(Material.AIR));
    }

    public ItemBuilder(ItemStack itemStack) {
        this.item = itemStack != null ? new ItemStack(itemStack) : new ItemStack(Material.AIR);
    }

    public ItemBuilder name(String name) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)CC.color(name));
            this.item.setItemMeta(meta);
        }
        return this;
    }

    private void clearFlags() {
        TooltipDisplay hideAttributes = (TooltipDisplay)TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{DataComponentTypes.POTION_CONTENTS, DataComponentTypes.ENCHANTMENTS, DataComponentTypes.ATTRIBUTE_MODIFIERS, DataComponentTypes.DYED_COLOR, DataComponentTypes.TRIM, DataComponentTypes.BANNER_PATTERNS, DataComponentTypes.FIREWORKS, DataComponentTypes.JUKEBOX_PLAYABLE}).build();
        this.item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)hideAttributes);
    }

    public ItemBuilder makeUnbreakable() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.setUnbreakable(true);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder setCustomModelData(int customData) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.setCustomModelData(Integer.valueOf(customData));
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public void resetAmount() {
        this.item.setAmount(1);
    }

    public ItemBuilder lore(List<String> lore) {
        return this.lore(lore.toArray(new String[0]));
    }

    public ItemBuilder lore(List<String> lore, Player player) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            ArrayList<TextComponent> toSet = new ArrayList<TextComponent>();
            for (String string : PlaceholderUtil.format(lore, player)) {
                toSet.add(CC.color(string));
            }
            meta.lore(toSet);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder lore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            ArrayList<TextComponent> toSet = new ArrayList<TextComponent>();
            for (String string : lore) {
                toSet.add(CC.color(string));
            }
            meta.lore(toSet);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount <= 0 ? 1 : Math.min(amount, 64));
        return this;
    }

    public ItemStack build() {
        this.clearFlags();
        return this.item;
    }
}

