/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.providers.clickable.Replacement;
import dev.lrxh.neptune.utils.ServerUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public final class ItemUtils {
    public static ItemStack[] color(ItemStack[] itemStackList, Color color) {
        ItemStack[] items = new ItemStack[itemStackList.length];
        for (int i = 0; i < itemStackList.length; ++i) {
            ItemStack itemStack = itemStackList[i];
            if (itemStack == null) continue;
            if (itemStack.getType() == Material.LEATHER_BOOTS || itemStack.getType() == Material.LEATHER_CHESTPLATE || itemStack.getType() == Material.LEATHER_HELMET || itemStack.getType() == Material.LEATHER_LEGGINGS) {
                LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
                meta.setColor(color);
                itemStack.setItemMeta((ItemMeta)meta);
            } else if (itemStack.getType().name().contains("WOOL")) {
                itemStack.setType(color.equals((Object)Color.BLUE) ? Material.BLUE_WOOL : Material.RED_WOOL);
            }
            items[i] = itemStack;
        }
        return items;
    }

    public static String serialize(List<ItemStack> items) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (items == null) {
            items = new ArrayList<ItemStack>();
        }
        try {
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)new GZIPOutputStream(outputStream));
            dataOutput.writeInt(items.size());
            for (ItemStack item : items) {
                if (item == null) {
                    item = new ItemStack(Material.AIR);
                }
                dataOutput.writeObject((Object)item);
            }
            dataOutput.close();
        }
        catch (IOException e) {
            ServerUtils.error("Occurred while saving items " + e.getMessage());
            return null;
        }
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static String serialize(ItemStack item) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)new GZIPOutputStream(outputStream));
            dataOutput.writeObject((Object)item);
            dataOutput.close();
        }
        catch (IOException e) {
            ServerUtils.error("Occurred while saving item " + e.getMessage());
            return null;
        }
        return Base64.getEncoder().encodeToString(outputStream.toByteArray());
    }

    public static List<ItemStack> deserialize(String base64) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (base64 == null) {
            return items;
        }
        byte[] data = Base64.getDecoder().decode(base64);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)new GZIPInputStream(inputStream));
            int size = dataInput.readInt();
            for (int i = 0; i < size; ++i) {
                ItemStack item = (ItemStack)dataInput.readObject();
                items.add(item);
            }
            dataInput.close();
        }
        catch (IOException | ClassNotFoundException e) {
            ServerUtils.error("Occurred while loading items " + e.getMessage());
            return null;
        }
        return items;
    }

    public static List<String> getLore(List<String> lore, Replacement ... replacements) {
        ArrayList<String> newLore = new ArrayList<String>();
        Iterator<String> iterator = lore.iterator();
        while (iterator.hasNext()) {
            String line;
            String modifiedLine = line = iterator.next();
            for (Replacement replacement : replacements) {
                if (!modifiedLine.contains(replacement.getPlaceholder())) continue;
                modifiedLine = modifiedLine.replace(replacement.getPlaceholder(), (CharSequence)MiniMessage.miniMessage().serialize((Component)replacement.getReplacement()));
            }
            List<String> splitLines = Arrays.asList(modifiedLine.split("<br>"));
            newLore.addAll(splitLines);
        }
        return newLore;
    }

    public static ItemStack deserializeItem(String base64) {
        byte[] data = Base64.getDecoder().decode(base64);
        ItemStack item = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)new GZIPInputStream(inputStream));
            item = (ItemStack)dataInput.readObject();
            dataInput.close();
        }
        catch (IOException | ClassNotFoundException e) {
            ServerUtils.error("Occurred while loading item!");
        }
        return item;
    }

    @Generated
    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

