/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationUtil {
    public static Location addOffset(Location location, int offsetX, int offsetZ) {
        return location.clone().add((double)offsetX, 0.0, (double)offsetZ);
    }

    public static boolean isInside(Location location, Location min, Location max) {
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        return x >= Math.min(min.getX(), max.getX()) && x <= Math.max(min.getX(), max.getX()) && y >= Math.min(min.getY(), max.getY()) && y <= Math.max(min.getY(), max.getY()) && z >= Math.min(min.getZ(), max.getZ()) && z <= Math.max(min.getZ(), max.getZ());
    }

    public static String serialize(Location location) {
        if (location == null) {
            return "";
        }
        return location.getWorld().getName() + ";" + location.getX() + ";" + location.getY() + ";" + location.getZ() + ";" + location.getYaw() + ";" + location.getPitch();
    }

    public static Location deserialize(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        String[] parts = input.split(";");
        if (parts.length < 6) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        try {
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            float yaw = Float.parseFloat(parts[4]);
            float pitch = Float.parseFloat(parts[5]);
            return new Location(world, x, y, z, yaw, pitch);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

