/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.API;
import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.profile.data.ProfileState;
import dev.lrxh.neptune.profile.impl.Profile;
import dev.lrxh.neptune.utils.CC;
import java.time.Duration;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public final class PlayerUtil {
    public static void reset(Player player) {
        player.setSaturation(20.0f);
        player.setFallDistance(0.0f);
        player.setFoodLevel(20);
        player.setFireTicks(0);
        player.setMaximumNoDamageTicks(20);
        player.setExp(0.0f);
        player.setLevel(0);
        player.setAllowFlight(false);
        player.setFlying(false);
        Profile profile = API.getProfile(player);
        if (profile.getState().equals(ProfileState.IN_LOBBY) || profile.getState().equals(ProfileState.IN_KIT_EDITOR) || profile.getState().equals(ProfileState.IN_PARTY) || profile.getState().equals(ProfileState.IN_QUEUE)) {
            player.setGameMode(GameMode.ADVENTURE);
        } else {
            player.setGameMode(GameMode.SURVIVAL);
        }
        player.getInventory().setArmorContents(new ItemStack[4]);
        player.getInventory().setContents(new ItemStack[36]);
        player.getActivePotionEffects().forEach(effect -> player.removePotionEffect(effect.getType()));
        player.updateInventory();
        player.resetTitle();
        player.setMaxHealth(20.0);
        player.setHealth(20.0);
        player.setCooldown(Material.ENDER_PEARL, 0);
        PlayerUtil.resetActionbar(player);
    }

    public static void resetActionbar(Player player) {
        player.sendActionBar(" ");
    }

    public static void teleportToSpawn(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        Location spawn = Neptune.get().getCache().getSpawn();
        if (spawn == null) {
            player.sendMessage((Component)CC.error("Make sure to set spawn location using /neptune setspawn!"));
            return;
        }
        player.teleport(spawn);
        for (Player spawnPlayer : spawn.getWorld().getPlayers()) {
            if (spawnPlayer.equals((Object)player)) continue;
            spawnPlayer.showPlayer((Plugin)Neptune.get(), player);
            player.showPlayer((Plugin)Neptune.get(), spawnPlayer);
        }
    }

    public static int getPing(Player player) {
        return player.getPing();
    }

    public static int getPing(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            throw new RuntimeException("Player UUID isn't valid");
        }
        return player.getPing();
    }

    public static ItemStack getPlayerHead(UUID playerUUID) {
        return PlayerUtil.getPlayerHead(playerUUID, 1);
    }

    public static ItemStack getPlayerHead(UUID playerUUID, int amount) {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD, amount);
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        meta.setOwningPlayer((OfflinePlayer)Bukkit.getPlayer((UUID)playerUUID));
        itemStack.setItemMeta((ItemMeta)meta);
        return itemStack;
    }

    public static void sendMessage(UUID playerUUID, Component message) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        player.sendMessage(message);
    }

    public static void sendMessage(UUID playerUUID, String message) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        player.sendMessage((Component)CC.color(message));
    }

    public static void sendTitle(Player player, TextComponent header, TextComponent footer, int duration) {
        if (header.content().equalsIgnoreCase("NONE") && footer.content().equalsIgnoreCase("NONE")) {
            return;
        }
        player.showTitle(Title.title((Component)header, (Component)footer, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis((long)duration * 50L), (Duration)Duration.ofMillis(500L))));
    }

    public static int getMaxDuration(Player player, PotionEffectType type) {
        if (player.hasMetadata("max_duration_" + type.getName())) {
            return ((MetadataValue)player.getMetadata("max_duration_" + type.getName()).get(0)).asInt();
        }
        return 0;
    }

    public static void doVelocityChange(UUID playerUUID) {
        Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            return;
        }
        player.setVelocity(player.getVelocity().add(new Vector(0.0, 0.25, 0.0)));
        player.setAllowFlight(true);
        player.setFlying(true);
        player.setVelocity(player.getVelocity().add(new Vector(0.0, 0.15, 0.0)));
        player.setAllowFlight(true);
        player.setFlying(true);
    }

    @Generated
    private PlayerUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

