/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import dev.lrxh.neptune.utils.TtlAction;
import dev.lrxh.neptune.utils.tasks.NeptuneRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TtlHashMap<K, V>
extends HashMap<K, V> {
    private final Map<K, TtlAction> actions = new HashMap<K, TtlAction>();
    private final long leaveTime;

    public TtlHashMap(long delay) {
        this.leaveTime = delay;
    }

    public void put(K key, V value, TtlAction action) {
        super.put(key, value);
        this.actions.put(key, action);
        this.scheduleRemoval(key);
    }

    public void onExpire(K key) {
        TtlAction action = this.actions.get(key);
        if (action != null) {
            Player player = Bukkit.getPlayer((UUID)action.getPlayerUUID());
            if (player != null) {
                action.getConsumer().accept(player);
            }
            this.actions.remove(key);
        }
    }

    public boolean contains(K key) {
        return this.containsKey(key);
    }

    @Override
    public V remove(Object key) {
        Object castKey = key;
        if (key != null && this.actions.containsKey(castKey)) {
            NeptuneRunnable runnable = this.actions.get(castKey).getRunnable();
            if (runnable != null) {
                runnable.stop();
            }
            this.actions.remove(castKey);
        }
        return super.remove(key);
    }

    private void scheduleRemoval(final K key) {
        TtlAction action = this.actions.get(key);
        if (action != null) {
            action.setRunnable(new NeptuneRunnable(){

                public void run() {
                    TtlHashMap.this.remove(key);
                    TtlHashMap.this.onExpire(key);
                }
            }, this.leaveTime);
        }
    }
}

