/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class WorldUtils {
    public static Set<Player> getPlayersInRadius(Location center, double radius) {
        World world = center.getWorld();
        if (world == null) {
            return new HashSet<Player>();
        }
        HashSet<Player> nearbyEntities = new HashSet<Player>();
        int chunkRadius = (int)Math.ceil(radius / 16.0);
        int centerChunkX = center.getBlockX() >> 4;
        int centerChunkZ = center.getBlockZ() >> 4;
        for (int dx = -chunkRadius; dx <= chunkRadius; ++dx) {
            for (int dz = -chunkRadius; dz <= chunkRadius; ++dz) {
                int chunkX = centerChunkX + dx;
                int chunkZ = centerChunkZ + dz;
                if (!world.isChunkLoaded(chunkX, chunkZ)) continue;
                for (Entity entity : world.getChunkAt(chunkX, chunkZ).getEntities()) {
                    if (entity == null || !(entity instanceof Player)) continue;
                    Player player = (Player)entity;
                    if (entity.getLocation().distanceSquared(center) > radius * radius) continue;
                    nearbyEntities.add(player);
                }
            }
        }
        return nearbyEntities;
    }

    @Generated
    private WorldUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

