/*
 * Decompiled with CFR 0.152.
 */
package dev.lrxh.neptune.utils.menu;

import dev.lrxh.neptune.Neptune;
import dev.lrxh.neptune.configs.impl.MenusLocale;
import dev.lrxh.neptune.utils.CC;
import dev.lrxh.neptune.utils.ServerUtils;
import dev.lrxh.neptune.utils.menu.Button;
import dev.lrxh.neptune.utils.menu.Filter;
import dev.lrxh.neptune.utils.menu.MenuService;
import dev.lrxh.neptune.utils.menu.impl.DisplayButton;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class Menu {
    private final int size;
    private final boolean updateOnClick;
    private final String title;
    private final Filter filter;
    private List<Button> buttons;
    private boolean updateEveryTick;
    private Inventory inventory;

    public Menu(String title, int size, Filter filter) {
        this.title = title;
        this.size = size;
        this.filter = filter;
        this.updateOnClick = false;
        this.updateEveryTick = false;
    }

    public Menu(int size, Filter filter) {
        this.title = "";
        this.size = size;
        this.filter = filter;
        this.updateOnClick = false;
        this.updateEveryTick = false;
    }

    public Menu(String title, int size, Filter filter, boolean updateOnClick) {
        this.title = title;
        this.size = size;
        this.filter = filter;
        this.updateOnClick = updateOnClick;
        this.updateEveryTick = false;
    }

    public abstract List<Button> getButtons(Player var1);

    public String getTitle(Player player) {
        return "";
    }

    private void set(Inventory inventory, int slot, ItemStack itemStack) {
        if (slot < inventory.getSize()) {
            inventory.setItem(slot, itemStack);
        } else {
            ServerUtils.error("Menu: " + this.title + " slot (" + slot + ") is larger than inventory size: (" + inventory.getSize() + ")");
        }
    }

    public void open(Player player) {
        Bukkit.getScheduler().runTask((Plugin)Neptune.get(), () -> {
            Inventory inventory;
            if (MenuService.get().getOpenedMenus().containsKey(player.getUniqueId())) {
                MenuService.get().remove(player);
            }
            String title = this.title.isEmpty() ? this.getTitle(player) : this.title;
            this.inventory = inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (Component)CC.color(title));
            player.openInventory(inventory);
            this.update(player);
            MenuService.get().add(player, this);
        });
    }

    public void update(Player player) {
        this.buttons = this.getButtons(player);
        switch (this.filter) {
            case FILL: {
                for (int i = 0; i < this.inventory.getSize(); ++i) {
                    if (this.getButton(i) != null) continue;
                    this.buttons.add(new DisplayButton(i, Material.getMaterial((String)MenusLocale.FILTER_MATERIAL.getString()), MenusLocale.FILTER_NAME.getString()));
                }
                break;
            }
            case BORDER: {
                int rows = this.size / 9;
                int columns = 9;
                for (int i = 0; i < this.size; ++i) {
                    int row = i / columns;
                    int column = i % columns;
                    if (row != 0 && row != rows - 1 && column != 0 && column != columns - 1 || this.getButton(i) != null) continue;
                    this.buttons.add(new DisplayButton(i, Material.getMaterial((String)MenusLocale.FILTER_MATERIAL.getString()), MenusLocale.FILTER_NAME.getString()));
                }
                break;
            }
        }
        for (Button button : this.buttons) {
            this.set(this.inventory, button.getSlot(), button.getItemStack(player));
        }
        player.updateInventory();
    }

    public Button getButton(int slot) {
        for (Button button : this.buttons) {
            if (button.getSlot() != slot) continue;
            return button;
        }
        return null;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public boolean isUpdateOnClick() {
        return this.updateOnClick;
    }

    @Generated
    public boolean isUpdateEveryTick() {
        return this.updateEveryTick;
    }

    @Generated
    public void setUpdateEveryTick(boolean updateEveryTick) {
        this.updateEveryTick = updateEveryTick;
    }
}

